/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.io.BaseOutputReader;
import gnu.trove.THashSet;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.OSProcessHandler");
    public static final Key<Set<File>> DELETE_FILES_ON_TERMINATION = Key.create((String)"OSProcessHandler.FileToDelete");
    private boolean myHasErrorStream = true;
    private boolean myHasPty;
    private boolean myDestroyRecursively = true;
    private Set<File> myFilesToDelete = null;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        this(OSProcessHandler.startProcess(commandLine), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myHasErrorStream = !commandLine.isRedirectErrorStream();
        this.myFilesToDelete = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
    }

    private static Process startProcess(GeneralCommandLine commandLine) throws ExecutionException {
        try {
            return commandLine.createProcess();
        }
        catch (ExecutionException | Error | RuntimeException e) {
            OSProcessHandler.deleteTempFiles(commandLine.getUserData(DELETE_FILES_ON_TERMINATION));
            throw e;
        }
    }

    private static void deleteTempFiles(Set<File> tempFiles) {
        if (tempFiles != null) {
            try {
                for (File file : tempFiles) {
                    FileUtil.delete((File)file);
                }
            }
            catch (Throwable t) {
                LOG.error("failed to delete temp. files", t);
            }
        }
    }

    @Deprecated
    public OSProcessHandler(@NotNull Process process) {
        this(process, null);
    }

    public OSProcessHandler(@NotNull Process process, String commandLine) {
        this(process, commandLine, EncodingManager.getInstance().getDefaultCharset());
    }

    public OSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        super(process, commandLine, charset);
        this.setHasPty(OSProcessHandler.isPtyProcess(process));
    }

    private static boolean isPtyProcess(Process process) {
        for (Class<?> c = process.getClass(); c != null; c = c.getSuperclass()) {
            if (!"com.pty4j.unix.UnixPtyProcess".equals(c.getName()) && !"com.pty4j.windows.WinPtyProcess".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
        return super.executeOnPooledThread(task);
    }

    protected void onOSProcessTerminated(int exitCode) {
        super.onOSProcessTerminated(exitCode);
        OSProcessHandler.deleteTempFiles(this.myFilesToDelete);
    }

    protected boolean processHasSeparateErrorStream() {
        return this.myHasErrorStream;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process)) {
            this.killProcessTree(process);
        } else {
            process.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process) {
        return !(process instanceof SelfKiller);
    }

    protected void killProcessTree(@NotNull Process process) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.killProcessTreeSync(process);
        } else {
            this.executeTask(() -> this.killProcessTreeSync(process));
        }
    }

    private void killProcessTreeSync(@NotNull Process process) {
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessManager.getInstance().killProcessTree(process);
        if (!destroyed) {
            if (!process.isAlive()) {
                LOG.warn("Process has been already terminated: " + this.myCommandLine);
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
                process.destroy();
            }
        }
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return this.myHasPty ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
    }

    public static void deleteFileOnTermination(@NotNull GeneralCommandLine commandLine, @NotNull File fileToDelete) {
        THashSet set = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
        if (set == null) {
            set = new THashSet();
            commandLine.putUserData(DELETE_FILES_ON_TERMINATION, set);
        }
        set.add((File)fileToDelete);
    }
}

