/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.StatusBar;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class ProcessTerminatedListener
extends ProcessAdapter {
    protected static final String EXIT_CODE_ENTRY = "$EXIT_CODE$";
    protected static final String EXIT_CODE_REGEX = "\\$EXIT_CODE\\$";
    private static final Key<ProcessTerminatedListener> KEY = new Key("processTerminatedListener");
    private final String myProcessFinishedMessage;
    private final Project myProject;

    private ProcessTerminatedListener(Project project, String processFinishedMessage) {
        this.myProject = project;
        this.myProcessFinishedMessage = processFinishedMessage;
    }

    public static void attach(ProcessHandler processHandler, Project project, String message) {
        ProcessTerminatedListener previousListener = (ProcessTerminatedListener)((Object)processHandler.getUserData(KEY));
        if (previousListener != null) {
            processHandler.removeProcessListener((ProcessListener)previousListener);
            if (project == null) {
                project = previousListener.myProject;
            }
        }
        ProcessTerminatedListener listener = new ProcessTerminatedListener(project, message);
        processHandler.addProcessListener((ProcessListener)listener);
        processHandler.putUserData(KEY, (Object)listener);
    }

    public static void attach(ProcessHandler processHandler, Project project) {
        String message = IdeBundle.message("finished.with.exit.code.text.message", EXIT_CODE_ENTRY);
        ProcessTerminatedListener.attach(processHandler, project, "\n" + message + "\n");
    }

    public static void attach(ProcessHandler processHandler) {
        ProcessTerminatedListener.attach(processHandler, null);
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        ProcessHandler processHandler = event.getProcessHandler();
        processHandler.removeProcessListener((ProcessListener)this);
        String message = this.myProcessFinishedMessage.replaceAll(EXIT_CODE_REGEX, ProcessTerminatedListener.stringifyExitCode(event.getExitCode()));
        processHandler.notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        if (this.myProject != null) {
            ApplicationManager.getApplication().invokeLater(() -> StatusBar.Info.set(message, this.myProject), this.myProject.getDisposed());
        }
    }

    @NotNull
    private static String stringifyExitCode(int exitCode) {
        StringBuilder result2 = new StringBuilder();
        result2.append(exitCode);
        if (SystemInfo.isWindows && exitCode >= -1073741824 && exitCode < -805306368) {
            result2.append(" (0x").append(Integer.toHexString(exitCode).toUpperCase(Locale.ENGLISH));
            if (exitCode == -1073741510) {
                result2.append(": interrupted by Ctrl+C");
            }
            result2.append(')');
        } else if (SystemInfo.isUnix && exitCode >= 129 && exitCode <= 159) {
            String[] signals = new String[]{"HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "INFO", "USR1", "USR2"};
            int signal = exitCode - 128;
            result2.append(" (interrupted by signal ").append(signal).append(": SIG").append(signals[signal - 1]).append(')');
        }
        return result2.toString();
    }
}

