/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.options.SettingsEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProgramRunner<Settings extends RunnerSettings>
implements ProgramRunner<Settings> {
    @Override
    @Nullable
    public Settings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return null;
    }

    @Override
    public void checkConfiguration(RunnerSettings settings, ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
    }

    @Override
    public void onProcessStarted(RunnerSettings settings, ExecutionResult executionResult) {
    }

    @Override
    @Nullable
    public SettingsEditor<Settings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        return null;
    }

    @Override
    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        this.execute(environment, null);
    }

    @Override
    public void execute(@NotNull ExecutionEnvironment environment, @Nullable ProgramRunner.Callback callback) throws ExecutionException {
        RunProfileState state = environment.getState();
        if (state == null) {
            return;
        }
        RunManager.getInstance(environment.getProject()).refreshUsagesList(environment.getRunProfile());
        this.execute(environment, callback, state);
    }

    protected abstract void execute(@NotNull ExecutionEnvironment var1, @Nullable ProgramRunner.Callback var2, @NotNull RunProfileState var3) throws ExecutionException;

    @Nullable
    static RunContentDescriptor postProcess(@NotNull ExecutionEnvironment environment, @Nullable RunContentDescriptor descriptor, @Nullable ProgramRunner.Callback callback) {
        if (descriptor != null) {
            RunnerAndConfigurationSettings settings;
            descriptor.setExecutionId(environment.getExecutionId());
            String toolWindowId = ExecutionManager.getInstance(environment.getProject()).getContentManager().getContentDescriptorToolWindowId(environment);
            if (toolWindowId != null) {
                descriptor.setContentToolWindowId(toolWindowId);
            }
            if ((settings = environment.getRunnerAndConfigurationSettings()) != null) {
                descriptor.setActivateToolWindowWhenAdded(settings.isActivateToolWindowBeforeRun());
            }
        }
        if (callback != null) {
            callback.processStarted(descriptor);
        }
        return descriptor;
    }
}

