/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionEnvironment
extends UserDataHolderBase
implements Disposable {
    private static final AtomicLong myIdHolder = new AtomicLong(1L);
    @NotNull
    private final Project myProject;
    @NotNull
    private RunProfile myRunProfile;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private ExecutionTarget myTarget;
    @Nullable
    private RunnerSettings myRunnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    @Nullable
    private final RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    @Nullable
    private RunContentDescriptor myContentToReuse;
    private final ProgramRunner<?> myRunner;
    private long myExecutionId = 0L;
    @Nullable
    private DataContext myDataContext;

    public ExecutionEnvironment() {
        this.myProject = null;
        this.myContentToReuse = null;
        this.myRunnerAndConfigurationSettings = null;
        this.myExecutor = null;
        this.myRunner = null;
    }

    public ExecutionEnvironment(@NotNull Executor executor, @NotNull ProgramRunner runner, @NotNull RunnerAndConfigurationSettings settings, @NotNull Project project) {
        this(settings.getConfiguration(), executor, DefaultExecutionTarget.INSTANCE, project, settings.getRunnerSettings(runner), settings.getConfigurationSettings(runner), null, settings, runner);
    }

    ExecutionEnvironment(@NotNull RunProfile runProfile, @NotNull Executor executor, @NotNull ExecutionTarget target, @NotNull Project project, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationSettings, @Nullable RunContentDescriptor contentToReuse, @Nullable RunnerAndConfigurationSettings settings, @NotNull ProgramRunner<?> runner) {
        this.myExecutor = executor;
        this.myTarget = target;
        this.myRunProfile = runProfile;
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
        this.myProject = project;
        this.setContentToReuse(contentToReuse);
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunner = runner;
    }

    public void dispose() {
        this.myContentToReuse = null;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        return this.myTarget;
    }

    @NotNull
    public RunProfile getRunProfile() {
        return this.myRunProfile;
    }

    @Nullable
    public RunnerAndConfigurationSettings getRunnerAndConfigurationSettings() {
        return this.myRunnerAndConfigurationSettings;
    }

    @Nullable
    public RunContentDescriptor getContentToReuse() {
        return this.myContentToReuse;
    }

    public void setContentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        if (contentToReuse != null) {
            Disposer.register((Disposable)contentToReuse, (Disposable)this);
        }
    }

    @NotNull
    public ProgramRunner<?> getRunner() {
        return this.myRunner;
    }

    @Nullable
    public RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myConfigurationSettings;
    }

    @Nullable
    public RunProfileState getState() throws ExecutionException {
        return this.myRunProfile.getState(this.myExecutor, this);
    }

    public long assignNewExecutionId() {
        this.myExecutionId = myIdHolder.incrementAndGet();
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    @NotNull
    public Executor getExecutor() {
        return this.myExecutor;
    }

    public String toString() {
        if (this.myRunnerAndConfigurationSettings != null) {
            return this.myRunnerAndConfigurationSettings.getName();
        }
        if (this.myRunProfile != null) {
            return this.myRunProfile.getName();
        }
        if (this.myContentToReuse != null) {
            return this.myContentToReuse.getDisplayName();
        }
        return super.toString();
    }

    void setDataContext(@NotNull DataContext dataContext) {
        this.myDataContext = CachingDataContext.cacheIfNeed(dataContext);
    }

    @Nullable
    public DataContext getDataContext() {
        return this.myDataContext;
    }

    public static long getNextUnusedExecutionId() {
        return myIdHolder.incrementAndGet();
    }

    private static class CachingDataContext
    implements DataContext {
        private static final DataKey[] keys = new DataKey[]{LangDataKeys.PROJECT, LangDataKeys.PROJECT_FILE_DIRECTORY, LangDataKeys.EDITOR, LangDataKeys.VIRTUAL_FILE, LangDataKeys.MODULE, LangDataKeys.PSI_FILE};
        private final Map<String, Object> values = new HashMap<String, Object>();

        @NotNull
        static CachingDataContext cacheIfNeed(@NotNull DataContext context) {
            if (context instanceof CachingDataContext) {
                return (CachingDataContext)context;
            }
            return new CachingDataContext(context);
        }

        private CachingDataContext(DataContext context) {
            for (DataKey key : keys) {
                this.values.put(key.getName(), key.getData(context));
            }
        }

        @Override
        public Object getData(@NotNull @NonNls String dataId) {
            return this.values.get(dataId);
        }
    }
}

