/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProvider;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionEnvironmentBuilder {
    private RunProfile myRunProfile;
    @NotNull
    private ExecutionTarget myTarget = DefaultExecutionTarget.INSTANCE;
    @NotNull
    private final Project myProject;
    @Nullable
    private RunnerSettings myRunnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    @Nullable
    private RunContentDescriptor myContentToReuse;
    @Nullable
    private RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    private ProgramRunner<?> myRunner;
    private boolean myAssignNewId;
    @Nullable
    private Long myExecutionId = null;
    @NotNull
    private Executor myExecutor;
    @Nullable
    private DataContext myDataContext;
    @Nullable
    private UserDataHolderBase myCopyableUserDataHolder;
    private final UserDataHolderBase myUserData = new UserDataHolderBase();

    public ExecutionEnvironmentBuilder(@NotNull Project project, @NotNull Executor executor) {
        this.myProject = project;
        this.myExecutor = executor;
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) throws ExecutionException {
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(project, executor, runProfile);
        if (builder == null) {
            throw new ExecutionException("Cannot find runner for " + runProfile.getName());
        }
        return builder;
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) {
        ProgramRunner<RunnerSettings> runner = ProgramRunner.getRunner(executor.getId(), runProfile);
        if (runner == null) {
            return null;
        }
        return new ExecutionEnvironmentBuilder(project, executor).runner(runner).runProfile(runProfile);
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(executor, settings.getConfiguration());
        return builder == null ? null : builder.runnerAndSettings(builder.myRunner, settings);
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(configuration.getProject(), executor, configuration);
        if (builder != null) {
            builder.runProfile(configuration);
        }
        return builder;
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) throws ExecutionException {
        RunConfiguration configuration = settings.getConfiguration();
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create(configuration.getProject(), executor, configuration);
        return builder.runnerAndSettings(builder.myRunner, settings);
    }

    @NotNull
    public static ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        return new ExecutionEnvironmentBuilder(configuration.getProject(), executor).runProfile(configuration);
    }

    @NotNull
    Executor getExecutor() {
        return this.myExecutor;
    }

    public ExecutionEnvironmentBuilder(@NotNull ExecutionEnvironment copySource) {
        this.myTarget = copySource.getExecutionTarget();
        this.myProject = copySource.getProject();
        this.myRunnerAndConfigurationSettings = copySource.getRunnerAndConfigurationSettings();
        this.myRunProfile = copySource.getRunProfile();
        this.myRunnerSettings = copySource.getRunnerSettings();
        this.myConfigurationSettings = copySource.getConfigurationSettings();
        this.myRunner = copySource.getRunner();
        this.myContentToReuse = copySource.getContentToReuse();
        this.myExecutor = copySource.getExecutor();
        this.myCopyableUserDataHolder = new UserDataHolderBase();
        copySource.copyCopyableDataTo(this.myCopyableUserDataHolder);
        copySource.copyUserDataTo(this.myUserData);
    }

    public ExecutionEnvironmentBuilder target(@Nullable ExecutionTarget target) {
        if (target != null) {
            this.myTarget = target;
        }
        return this;
    }

    public ExecutionEnvironmentBuilder activeTarget() {
        this.myTarget = ExecutionTargetManager.getActiveTarget(this.myProject);
        return this;
    }

    @NotNull
    public ExecutionEnvironmentBuilder runnerAndSettings(@NotNull ProgramRunner runner, @NotNull RunnerAndConfigurationSettings settings) {
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunProfile = settings.getConfiguration();
        this.myRunnerSettings = settings.getRunnerSettings(runner);
        this.myConfigurationSettings = settings.getConfigurationSettings(runner);
        this.myRunner = runner;
        return this;
    }

    public ExecutionEnvironmentBuilder runnerSettings(@Nullable RunnerSettings runnerSettings) {
        this.myRunnerSettings = runnerSettings;
        return this;
    }

    public ExecutionEnvironmentBuilder contentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        return this;
    }

    public ExecutionEnvironmentBuilder runProfile(@NotNull RunProfile runProfile) {
        this.myRunProfile = runProfile;
        return this;
    }

    @NotNull
    public ExecutionEnvironmentBuilder runner(@NotNull ProgramRunner<?> runner) {
        this.myRunner = runner;
        return this;
    }

    public ExecutionEnvironmentBuilder dataContext(@Nullable DataContext dataContext) {
        this.myDataContext = dataContext;
        return this;
    }

    public ExecutionEnvironmentBuilder executor(@NotNull Executor executor) {
        this.myExecutor = executor;
        return this;
    }

    public ExecutionEnvironmentBuilder executionId(long executionId) {
        this.myExecutionId = executionId;
        this.myAssignNewId = false;
        return this;
    }

    @NotNull
    public ExecutionEnvironment build() {
        ExecutionEnvironment environment = null;
        ExecutionEnvironmentProvider environmentProvider = ServiceManager.getService(this.myProject, ExecutionEnvironmentProvider.class);
        if (environmentProvider != null) {
            environment = environmentProvider.createExecutionEnvironment(this.myProject, this.myRunProfile, this.myExecutor, this.myTarget, this.myRunnerSettings, this.myConfigurationSettings, this.myRunnerAndConfigurationSettings);
        }
        if (environment == null && this.myRunner == null) {
            this.myRunner = ProgramRunner.getRunner(this.myExecutor.getId(), this.myRunProfile);
        }
        if (environment == null && this.myRunner == null) {
            throw new IllegalStateException("Runner must be specified");
        }
        if (environment == null) {
            environment = new ExecutionEnvironment(this.myRunProfile, this.myExecutor, this.myTarget, this.myProject, this.myRunnerSettings, this.myConfigurationSettings, this.myContentToReuse, this.myRunnerAndConfigurationSettings, this.myRunner);
        }
        if (this.myAssignNewId) {
            environment.assignNewExecutionId();
        }
        if (this.myExecutionId != null) {
            environment.setExecutionId(this.myExecutionId);
        }
        if (this.myDataContext != null) {
            environment.setDataContext(this.myDataContext);
        }
        if (this.myCopyableUserDataHolder != null) {
            this.myCopyableUserDataHolder.copyCopyableDataTo((UserDataHolderBase)environment);
        }
        this.myUserData.copyUserDataTo((UserDataHolderBase)environment);
        return environment;
    }

    public void buildAndExecute() throws ExecutionException {
        ExecutionEnvironment environment = this.build();
        this.myRunner.execute(environment);
    }
}

