/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SettingsEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProgramRunner<Settings extends RunnerSettings> {
    public static final ExtensionPointName<ProgramRunner<RunnerSettings>> PROGRAM_RUNNER_EP = ExtensionPointName.create((String)"com.intellij.programRunner");

    @Nullable
    public static ProgramRunner findRunnerById(@NotNull String id) {
        for (ProgramRunner registeredRunner : PROGRAM_RUNNER_EP.getExtensionList()) {
            if (!id.equals(registeredRunner.getRunnerId())) continue;
            return registeredRunner;
        }
        return null;
    }

    @Nullable
    public static ProgramRunner<RunnerSettings> getRunner(@NotNull String executorId, @NotNull RunProfile settings) {
        for (ProgramRunner runner : PROGRAM_RUNNER_EP.getExtensionList()) {
            if (!runner.canRun(executorId, settings)) continue;
            return runner;
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getRunnerId();

    public boolean canRun(@NotNull String var1, @NotNull RunProfile var2);

    @Nullable
    public Settings createConfigurationData(ConfigurationInfoProvider var1);

    public void checkConfiguration(RunnerSettings var1, @Nullable ConfigurationPerRunnerSettings var2) throws RuntimeConfigurationException;

    public void onProcessStarted(RunnerSettings var1, ExecutionResult var2);

    @Nullable
    public SettingsEditor<Settings> getSettingsEditor(Executor var1, RunConfiguration var2);

    public void execute(@NotNull ExecutionEnvironment var1) throws ExecutionException;

    public void execute(@NotNull ExecutionEnvironment var1, @Nullable Callback var2) throws ExecutionException;

    public static interface Callback {
        public void processStarted(RunContentDescriptor var1);
    }
}

