/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ServiceViewContributor<T, Group, State> {
    public static final Topic<ServiceListener> TOPIC = Topic.create((String)"services topic", ServiceListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_CHILDREN);

    @NotNull
    public List<T> getNodes(@NotNull Project var1);

    public List<Group> getGroups(@NotNull T var1);

    @NotNull
    public State getState(@NotNull T var1);

    @NotNull
    public ViewDescriptor getGroupDescriptor(@NotNull Group var1);

    @NotNull
    public ViewDescriptor getNodeDescriptor(@NotNull T var1);

    @NotNull
    public ViewDescriptor getStateDescriptor(@NotNull State var1);

    @Nullable
    default public ViewDescriptorRenderer getViewDescriptorRenderer() {
        return null;
    }

    @Nullable
    default public SubtreeDescriptor<?> getNodeSubtree(@NotNull T node) {
        return null;
    }

    public static enum EventType {
        RESET,
        SERVICE_ADDED,
        SERVICE_REMOVED,
        SERVICE_CHANGED,
        GROUP_CHANGED,
        SUBTREE_CHANGED,
        ITEM_CHANGED;

    }

    public static final class ServiceEvent {
        public final EventType type;
        public final Object target;
        public final Class<?> contributorClass;

        public ServiceEvent(@NotNull Class<?> contributorClass) {
            this(EventType.RESET, contributorClass, contributorClass);
        }

        public ServiceEvent(@NotNull EventType type, @NotNull Object target, @NotNull Class<?> contributorClass) {
            this.type = type;
            this.target = target;
            this.contributorClass = contributorClass;
        }
    }

    public static interface ServiceListener {
        public void handle(@NotNull ServiceEvent var1);
    }

    public static interface ViewDescriptorRenderer {
        @Nullable
        public Component getRendererComponent(JComponent var1, Object var2, ViewDescriptor var3, boolean var4, boolean var5);
    }

    public static interface ViewDescriptor {
        public JComponent getContentComponent();

        public ActionGroup getToolbarActions();

        default public ActionGroup getPopupActions() {
            return this.getToolbarActions();
        }

        public ItemPresentation getPresentation();

        public DataProvider getDataProvider();

        default public void onNodeSelected() {
        }

        default public void onNodeUnselected() {
        }

        default public boolean handleDoubleClick(@NotNull MouseEvent event) {
            return false;
        }
    }

    public static interface SubtreeDescriptor<TT> {
        @NotNull
        public List<TT> getItems();

        @NotNull
        public ViewDescriptor getItemDescriptor(@NotNull TT var1);

        @Nullable
        default public SubtreeDescriptor<?> getNodeSubtree(@NotNull TT node) {
            return null;
        }
    }
}

