/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.util.PathMappingTable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathMappingsComponent
extends LabeledComponent<TextFieldWithBrowseButton>
implements UserActivityProviderComponent {
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private PathMappingSettings myMappingSettings = new PathMappingSettings();

    public PathMappingsComponent() {
        TextFieldWithBrowseButton pathTextField = new TextFieldWithBrowseButton();
        pathTextField.setEditable(false);
        this.setComponent(pathTextField);
        this.setText("Path mappings:");
        ((TextFieldWithBrowseButton)this.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathMappingsComponent.this.showConfigureMappingsDialog();
            }
        });
    }

    private void showConfigureMappingsDialog() {
        new MyPathMappingsDialog(this).show();
    }

    @NotNull
    public PathMappingSettings getMappingSettings() {
        return this.myMappingSettings;
    }

    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings == null ? new PathMappingSettings() : mappingSettings;
        this.setTextRepresentation(this.myMappingSettings);
        this.fireStateChanged();
    }

    private void setTextRepresentation(@NotNull PathMappingSettings mappingSettings) {
        StringBuilder sb = new StringBuilder();
        for (PathMappingSettings.PathMapping mapping : mappingSettings.getPathMappings()) {
            sb.append(mapping.getLocalRoot()).append("=").append(mapping.getRemoteRoot()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        ((TextFieldWithBrowseButton)this.getComponent()).setText(sb.toString());
    }

    @Override
    public void addChangeListener(@NotNull ChangeListener changeListener) {
        this.myListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private static class MyPathMappingsDialog
    extends DialogWrapper {
        private final PathMappingTable myPathMappingTable;
        private final JPanel myWholePanel = new JPanel(new BorderLayout());
        private final PathMappingsComponent myMappingsComponent;

        protected MyPathMappingsDialog(PathMappingsComponent mappingsComponent) {
            super(mappingsComponent, true);
            this.myMappingsComponent = mappingsComponent;
            this.myPathMappingTable = new PathMappingTable();
            this.myPathMappingTable.setValues(mappingsComponent.getMappingSettings().getPathMappings());
            this.myWholePanel.add((Component)this.myPathMappingTable.getComponent(), "Center");
            this.setTitle("Edit Path Mappings");
            this.init();
        }

        @Override
        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        @Override
        protected void doOKAction() {
            this.myPathMappingTable.stopEditing();
            this.myMappingsComponent.setMappingSettings(this.myPathMappingTable.getPathMappingSettings());
            super.doOKAction();
        }
    }
}

