/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDownloadInfo {
    @Nullable
    private final RemoteRepositoryInfo myRemoteRepository;
    private final String myRelativeDownloadUrl;
    private final String myFileNamePrefix;
    private final String myFileNameSuffix;
    @Nullable
    private final String myPresentableUrl;

    public LibraryDownloadInfo(@NotNull RemoteRepositoryInfo remoteRepository, @NotNull @NonNls String relativeDownloadUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        this.myRemoteRepository = remoteRepository;
        this.myRelativeDownloadUrl = relativeDownloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = null;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        this.myRemoteRepository = null;
        this.myRelativeDownloadUrl = downloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = presentableUrl != null ? presentableUrl : downloadUrl;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix) {
        this(downloadUrl, presentableUrl, fileNamePrefix, ".jar");
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @NotNull @NonNls String fileNamePrefix) {
        this(downloadUrl, null, fileNamePrefix);
    }

    @NotNull
    public String getDownloadUrl() {
        return this.myRemoteRepository != null ? this.getDownloadUrl(this.myRemoteRepository.getDefaultMirror()) : this.myRelativeDownloadUrl;
    }

    @NotNull
    public String getDownloadUrl(String mirror) {
        return mirror + this.myRelativeDownloadUrl;
    }

    @Nullable
    public RemoteRepositoryInfo getRemoteRepository() {
        return this.myRemoteRepository;
    }

    @NotNull
    public String getFileNamePrefix() {
        return this.myFileNamePrefix;
    }

    @NotNull
    public String getFileNameSuffix() {
        return this.myFileNameSuffix;
    }

    @NotNull
    public String getFileName() {
        return this.myFileNamePrefix + this.myFileNameSuffix;
    }

    @NotNull
    public String getPresentableUrl() {
        return this.myPresentableUrl != null ? this.myPresentableUrl : (this.myRemoteRepository != null ? this.myRemoteRepository.getDefaultMirror() : this.myRelativeDownloadUrl);
    }

    @NotNull
    public String getPresentableUrl(String mirror) {
        return this.myPresentableUrl != null ? this.myPresentableUrl : mirror;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryDownloadInfo that = (LibraryDownloadInfo)o;
        if (!this.myFileNamePrefix.equals(that.myFileNamePrefix)) {
            return false;
        }
        if (!this.myFileNameSuffix.equals(that.myFileNameSuffix)) {
            return false;
        }
        if (!Comparing.equal((String)this.myPresentableUrl, (String)that.myPresentableUrl)) {
            return false;
        }
        if (!this.myRelativeDownloadUrl.equals(that.myRelativeDownloadUrl)) {
            return false;
        }
        return Comparing.equal((Object)this.myRemoteRepository, (Object)that.myRemoteRepository);
    }

    public int hashCode() {
        int result2 = this.myRemoteRepository != null ? this.myRemoteRepository.hashCode() : 0;
        result2 = 31 * result2 + (this.myRelativeDownloadUrl != null ? this.myRelativeDownloadUrl.hashCode() : 0);
        result2 = 31 * result2 + (this.myFileNamePrefix != null ? this.myFileNamePrefix.hashCode() : 0);
        result2 = 31 * result2 + (this.myFileNameSuffix != null ? this.myFileNameSuffix.hashCode() : 0);
        result2 = 31 * result2 + (this.myPresentableUrl != null ? this.myPresentableUrl.hashCode() : 0);
        return result2;
    }
}

