/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.fileSet;

import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternDescriptor
implements FileSetDescriptor {
    public static final String PATTERN_TYPE = "pattern";
    @Nullable
    private String myRawPattern;
    @Nullable
    private Pattern myPathPattern;
    @Nullable
    private Pattern myFileNamePattern;
    private static final String FORBIDDEN_CHARS = "<>:\"\\;";

    public PatternDescriptor(@NotNull String pattern) {
        this.myRawPattern = pattern;
        this.compileSpec(this.myRawPattern);
    }

    private void compileSpec(@NotNull String spec) {
        String fileSpec;
        String pathSpec = "";
        int lastSlashPos = spec.lastIndexOf(47);
        if (lastSlashPos >= 0) {
            fileSpec = spec.substring(lastSlashPos + 1);
            pathSpec = spec.substring(0, lastSlashPos + 1);
            if (pathSpec.length() > 0 && pathSpec.charAt(0) != '/') {
                pathSpec = "/**/" + pathSpec;
            }
        } else {
            fileSpec = spec;
        }
        if (!pathSpec.isEmpty()) {
            this.myPathPattern = Pattern.compile(PatternDescriptor.specToRegexp(pathSpec, true));
        }
        if (!fileSpec.isEmpty()) {
            this.myFileNamePattern = Pattern.compile(PatternDescriptor.specToRegexp(fileSpec, false));
        }
    }

    private static String specToRegexp(@NotNull String spec, boolean isPathSpec) {
        StringBuilder sb = new StringBuilder();
        char[] chars = spec.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '*': {
                    if (isPathSpec && i < chars.length - 1 && chars[i + 1] == '*') {
                        sb.append("([^/]*/)*");
                        if (++i >= chars.length - 1 || chars[i + 1] != '/') continue block4;
                        ++i;
                        continue block4;
                    }
                    sb.append("[^/]*");
                    continue block4;
                }
                case '?': {
                    sb.append("[^/]");
                    continue block4;
                }
                default: {
                    if (PatternDescriptor.isRegexSpecialChar(c)) {
                        sb.append('\\').append(c);
                        continue block4;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static boolean isRegexSpecialChar(char c) {
        return "^${}[]().*+-&".indexOf(c) >= 0;
    }

    public boolean matches(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        if (this.myFileNamePattern == null && this.myPathPattern == null) {
            return false;
        }
        String name = virtualFile2.getName();
        VirtualFile parent = virtualFile2.getParent();
        String path2 = PatternDescriptor.getRelativePath(project, parent) + "/";
        return PatternDescriptor.patternMatches(this.myPathPattern, path2) && PatternDescriptor.patternMatches(this.myFileNamePattern, name);
    }

    @Override
    public boolean matches(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile2;
        if (psiFile.isValid() && (virtualFile2 = psiFile.getVirtualFile()) != null) {
            return this.matches(psiFile.getProject(), virtualFile2);
        }
        return false;
    }

    @NotNull
    private static String getRelativePath(@NotNull Project project, @Nullable VirtualFile parent) {
        VirtualFile projectDir = project.getBaseDir();
        String projectPath = projectDir.getPath();
        if (parent != null) {
            String parentPath = parent.getPath();
            if (parentPath.startsWith(projectPath)) {
                return parentPath.substring(projectPath.length());
            }
            return parentPath;
        }
        return "";
    }

    private static boolean patternMatches(@Nullable Pattern pattern, @NotNull String str) {
        return pattern == null || pattern.matcher(str).matches();
    }

    @Override
    public String getPattern() {
        return this.myRawPattern;
    }

    @Override
    public void setPattern(@Nullable String pattern) {
        this.myRawPattern = pattern;
        if (pattern != null) {
            this.compileSpec(pattern);
        } else {
            this.myPathPattern = null;
            this.myFileNamePattern = null;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof PatternDescriptor && Comparing.equal((String)this.myRawPattern, (String)((PatternDescriptor)obj).getPattern());
    }

    public static boolean isValidPattern(@NotNull String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            if (FORBIDDEN_CHARS.indexOf(pattern.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getType() {
        return PATTERN_TYPE;
    }

    public String toString() {
        return this.getType() + ": " + this.getPattern();
    }
}

