/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedFrameworkDetector<F extends Facet, C extends FacetConfiguration>
extends FrameworkDetector {
    private static final Logger LOG = Logger.getInstance(FacetBasedFrameworkDetector.class);

    protected FacetBasedFrameworkDetector(String detectorId) {
        super(detectorId);
    }

    protected FacetBasedFrameworkDetector(@NotNull String detectorId, int detectorVersion) {
        super(detectorId, detectorVersion);
    }

    @NotNull
    public abstract FacetType<F, C> getFacetType();

    @NotNull
    public List<Pair<C, Collection<VirtualFile>>> createConfigurations(@NotNull Collection<VirtualFile> files, @NotNull Collection<C> existentFacetConfigurations) {
        C configuration = this.createConfiguration(files);
        if (configuration != null) {
            return Collections.singletonList(Pair.create(configuration, files));
        }
        return Collections.emptyList();
    }

    @Nullable
    protected C createConfiguration(Collection<VirtualFile> files) {
        return this.getFacetType().createDefaultConfiguration();
    }

    public void setupFacet(@NotNull F facet, ModifiableRootModel model) {
    }

    @Override
    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        return context.createDetectedFacetDescriptions(this, newFiles);
    }

    @Override
    public FrameworkType getFrameworkType() {
        FacetType<F, C> type = this.getFacetType();
        LOG.assertTrue(type != null, (Object)("'getFacetType' returns 'null' in " + this.getClass()));
        return FacetBasedFrameworkDetector.createFrameworkType(type);
    }

    static FrameworkType createFrameworkType(FacetType<?, ?> facetType) {
        return new FacetBasedFrameworkType(facetType);
    }

    @Override
    public FrameworkType getUnderlyingFrameworkType() {
        FacetTypeId<?> underlyingTypeId = this.getFacetType().getUnderlyingFacetType();
        return underlyingTypeId != null ? FacetBasedFrameworkDetector.createFrameworkType(FacetTypeRegistry.getInstance().findFacetType(underlyingTypeId)) : null;
    }

    public boolean isSuitableUnderlyingFacetConfiguration(FacetConfiguration underlying, C configuration, Set<VirtualFile> files) {
        return true;
    }

    private static class FacetBasedFrameworkType
    extends FrameworkType {
        private final FacetType<?, ?> myFacetType;
        private final Icon myIcon;

        FacetBasedFrameworkType(@NotNull FacetType<?, ?> facetType) {
            super(facetType.getStringId());
            this.myFacetType = facetType;
            Icon icon = this.myFacetType.getIcon();
            this.myIcon = icon != null ? icon : EmptyIcon.ICON_16;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            return this.myFacetType.getPresentableName();
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

