/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.SmartSelectInContext;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEditorSelectInContext
extends SmartSelectInContext {
    private final TextEditor editor;

    public FileEditorSelectInContext(@NotNull FileEditor fileEditor, @NotNull PsiFile psiFile) {
        super(psiFile, psiFile, () -> fileEditor);
        this.editor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
    }

    @Override
    @Nullable
    public Object getSelectorInFile() {
        PsiFile file = this.getPsiFile();
        return file == null ? null : ObjectUtils.notNull((Object)this.getElementAtCaret(file, false), (Object)file);
    }

    @Nullable
    public PsiElement getElementAtCaret(boolean tryInjected) {
        PsiFile file = this.getPsiFile();
        return file == null ? null : this.getElementAtCaret(file, tryInjected);
    }

    @Nullable
    private PsiElement getElementAtCaret(@NotNull PsiFile file, boolean tryInjected) {
        InjectedLanguageManager manager;
        PsiElement injectedElementAt;
        Editor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        if (tryInjected && (injectedElementAt = (manager = InjectedLanguageManager.getInstance(this.getProject())).findInjectedElementAt(file, offset)) != null) {
            return injectedElementAt;
        }
        PsiElement elementAt = file.findElementAt(offset);
        if (offset > 0 && (elementAt == null || elementAt instanceof PsiWhiteSpace)) {
            elementAt = file.findElementAt(offset - 1);
        }
        return elementAt;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor == null ? null : this.editor.getEditor();
    }
}

