/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSelectInContext
implements SelectInContext {
    private final Project myProject;
    private final VirtualFile myFile;
    private final FileEditorProvider myProvider;

    public FileSelectInContext(@NotNull Project project, @NotNull VirtualFile file) {
        this(project, file, FileSelectInContext.getFileEditorProvider(project, file));
    }

    public FileSelectInContext(@NotNull Project project, @NotNull VirtualFile file, @Nullable FileEditorProvider provider) {
        this.myProject = project;
        this.myFile = file;
        this.myProvider = provider;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public Object getSelectorInFile() {
        return null;
    }

    @Override
    @Nullable
    public FileEditorProvider getFileEditorProvider() {
        return this.myProvider;
    }

    private static FileEditorProvider getFileEditorProvider(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorManager manager = FileEditorManager.getInstance(project);
        return manager == null ? null : () -> (FileEditor)ArrayUtil.getFirstElement((Object[])manager.openFile(file, false));
    }
}

