/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.pom.Navigatable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OccurenceNavigatorSupport
implements OccurenceNavigator {
    private final JTree myTree;

    public OccurenceNavigatorSupport(@NotNull JTree tree) {
        this.myTree = tree;
    }

    @Nullable
    protected abstract Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode var1);

    protected boolean isOccurrenceNode(@NotNull DefaultMutableTreeNode node) {
        return this.createDescriptorForNode(node) != null;
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, true);
        if (node == null) {
            return null;
        }
        TreePath treePath = new TreePath(node.getPath());
        TreeUtil.selectPath(this.myTree, treePath);
        Navigatable editSourceDescriptor = this.createDescriptorForNode(node);
        if (editSourceDescriptor == null) {
            return null;
        }
        Counters counters = this.calculatePosition(node);
        return new OccurenceNavigator.OccurenceInfo(editSourceDescriptor, counters.myFoundOccurenceNumber, counters.myOccurencesCount);
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, false);
        if (node == null) {
            return null;
        }
        TreePath treePath = new TreePath(node.getPath());
        TreeUtil.selectPath(this.myTree, treePath);
        Navigatable editSourceDescriptor = this.createDescriptorForNode(node);
        if (editSourceDescriptor == null) {
            return null;
        }
        Counters counters = this.calculatePosition(node);
        return new OccurenceNavigator.OccurenceInfo(editSourceDescriptor, counters.myFoundOccurenceNumber, counters.myOccurencesCount);
    }

    @NotNull
    private Counters calculatePosition(@NotNull DefaultMutableTreeNode foundNode) {
        Counters counters = new Counters();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)foundNode.getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode node = enumeration.nextElement();
            if (node instanceof DefaultMutableTreeNode && this.isOccurrenceNode((DefaultMutableTreeNode)node)) {
                ++counters.myOccurencesCount;
            }
            if (node != foundNode) continue;
            counters.myFoundOccurenceNumber = counters.myOccurencesCount;
        }
        return counters;
    }

    @Override
    public boolean hasNextOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, true);
        return node != null;
    }

    @Override
    public boolean hasPreviousOccurence() {
        DefaultMutableTreeNode node = this.findNode(this.myTree, false);
        return node != null;
    }

    private DefaultMutableTreeNode findNode(@NotNull JTree tree, boolean forward) {
        TreePath selectionPath = tree.getSelectionPath();
        TreeNode selectedNode = null;
        if (selectionPath != null) {
            selectedNode = (TreeNode)selectionPath.getLastPathComponent();
        }
        return this.findNextNodeAfter(tree, selectedNode, forward);
    }

    public DefaultMutableTreeNode findNextNodeAfter(@NotNull JTree tree, TreeNode selectedNode, boolean forward) {
        if (selectedNode == null) {
            selectedNode = (TreeNode)tree.getModel().getRoot();
        }
        if (forward) {
            for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)selectedNode).getNextNode(); node != null; node = node.getNextNode()) {
                if (this.createDescriptorForNode(node) == null) continue;
                return node;
            }
        } else {
            for (DefaultMutableTreeNode node = ((DefaultMutableTreeNode)selectedNode).getPreviousNode(); node != null; node = node.getPreviousNode()) {
                if (this.createDescriptorForNode(node) == null) continue;
                return node;
            }
        }
        return null;
    }

    private static class Counters {
        int myFoundOccurenceNumber;
        int myOccurencesCount;

        private Counters() {
        }
    }
}

