/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SelectInManager {
    private final Project myProject;
    private final List<SelectInTarget> myTargets = new ArrayList<SelectInTarget>();
    private boolean myLoadedExtensions = false;
    @NonNls
    public static final String PROJECT = IdeBundle.message("select.in.project", new Object[0]);
    @NonNls
    public static final String PACKAGES = IdeBundle.message("select.in.packages", new Object[0]);
    @NonNls
    public static final String ASPECTS = IdeBundle.message("select.in.aspects", new Object[0]);
    @NonNls
    public static final String COMMANDER = IdeBundle.message("select.in.commander", new Object[0]);
    @NonNls
    public static final String FAVORITES = IdeBundle.message("select.in.favorites", new Object[0]);
    @NonNls
    public static final String NAV_BAR = IdeBundle.message("select.in.nav.bar", new Object[0]);
    @NonNls
    public static final String SCOPE = IdeBundle.message("select.in.scope", new Object[0]);

    public SelectInManager(Project project) {
        this.myProject = project;
    }

    @Deprecated
    public void addTarget(SelectInTarget target) {
        this.myTargets.add(target);
    }

    public void removeTarget(SelectInTarget target) {
        this.myTargets.remove(target);
    }

    public SelectInTarget[] getTargets() {
        this.checkLoadExtensions();
        Stream<Object> stream = this.myTargets.stream();
        if (DumbService.getInstance(this.myProject).isDumb()) {
            stream = stream.filter(target -> DumbService.isDumbAware(target));
        }
        return (SelectInTarget[])stream.sorted(SelectInTargetComparator.INSTANCE).toArray(SelectInTarget[]::new);
    }

    private void checkLoadExtensions() {
        if (!this.myLoadedExtensions) {
            this.myLoadedExtensions = true;
            Collections.addAll(this.myTargets, SelectInTarget.EP_NAME.getExtensions((AreaInstance)this.myProject));
        }
    }

    public static SelectInManager getInstance(Project project) {
        return ServiceManager.getService(project, SelectInManager.class);
    }

    public static SelectInTarget findSelectInTarget(@NotNull String id, Project project) {
        SelectInTarget[] targets;
        SelectInManager manager = project == null || project.isDisposed() ? null : SelectInManager.getInstance(project);
        SelectInTarget[] selectInTargetArray = targets = manager == null ? null : manager.getTargets();
        if (targets != null) {
            for (SelectInTarget target : targets) {
                if (target == null || !Objects.equals(id, target.getToolWindowId())) continue;
                return target;
            }
        }
        return null;
    }

    public static class SelectInTargetComparator
    implements Comparator<SelectInTarget> {
        public static final Comparator<SelectInTarget> INSTANCE = new SelectInTargetComparator();

        @Override
        public int compare(SelectInTarget o1, SelectInTarget o2) {
            return Float.compare(o1.getWeight(), o2.getWeight());
        }
    }
}

