/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.FileSelectInContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class SmartSelectInContext
extends FileSelectInContext {
    private final SmartPsiElementPointer<PsiElement> pointer;

    public SmartSelectInContext(@NotNull PsiFile file, @NotNull PsiElement element) {
        super(file.getProject(), file.getViewProvider().getVirtualFile());
        this.pointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
    }

    public SmartSelectInContext(@NotNull PsiFile file, @NotNull PsiElement element, FileEditorProvider provider) {
        super(file.getProject(), file.getViewProvider().getVirtualFile(), provider);
        this.pointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
    }

    @Override
    public Object getSelectorInFile() {
        return this.pointer.getElement();
    }

    public PsiFile getPsiFile() {
        PsiElement selector = this.pointer.getElement();
        return selector instanceof PsiFile ? (PsiFile)selector : null;
    }
}

