/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.exclusion;

import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

abstract class TreeNodeExclusionAction<T extends TreeNode>
extends AnAction {
    private static final Logger LOG = Logger.getInstance(TreeNodeExclusionAction.class);
    private final boolean myIsExclude;

    TreeNodeExclusionAction(boolean isExclude) {
        this.myIsExclude = isExclude;
        this.getTemplatePresentation().setText(this.getActionText());
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        ExclusionHandler exclusionProcessor = ExclusionHandler.EXCLUSION_HANDLER.getData(e.getDataContext());
        if (exclusionProcessor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Component component = PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext());
        Presentation presentation = e.getPresentation();
        if (!(component instanceof JTree) || !exclusionProcessor.isActionEnabled(this.myIsExclude)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        JTree tree = (JTree)component;
        TreePath[] selection = TreeUtil.selectMaximals(tree.getSelectionPaths());
        if (selection.length == 0) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean[] isEnabled = new boolean[]{false};
        for (TreePath path2 : selection) {
            TreeNode node = (TreeNode)path2.getLastPathComponent();
            TreeUtil.traverse(node, n -> {
                if (!exclusionProcessor.isNodeExclusionAvailable((TreeNode)n)) {
                    return true;
                }
                boolean isNodeExcluded = exclusionProcessor.isNodeExcluded((TreeNode)n);
                if (this.myIsExclude != isNodeExcluded) {
                    isEnabled[0] = true;
                    return false;
                }
                return true;
            });
        }
        presentation.setEnabledAndVisible(isEnabled[0]);
        if (isEnabled[0]) {
            String text = this.getActionText();
            if (selection.length > 1) {
                text = text + " All";
            }
            presentation.setText(text);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        JTree tree = (JTree)PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext());
        LOG.assertTrue(tree != null);
        TreePath[] paths = tree.getSelectionPaths();
        LOG.assertTrue(paths != null);
        ExclusionHandler exclusionProcessor = ExclusionHandler.EXCLUSION_HANDLER.getData(e.getDataContext());
        LOG.assertTrue(exclusionProcessor != null);
        for (TreePath path2 : paths) {
            TreeNode node = (TreeNode)path2.getLastPathComponent();
            TreeUtil.traverse(node, n -> {
                if (!exclusionProcessor.isNodeExclusionAvailable((TreeNode)n)) {
                    return true;
                }
                if (this.myIsExclude != exclusionProcessor.isNodeExcluded((TreeNode)n)) {
                    if (this.myIsExclude) {
                        exclusionProcessor.excludeNode(node);
                    } else {
                        exclusionProcessor.includeNode(node);
                    }
                }
                return true;
            });
        }
        exclusionProcessor.onDone(this.myIsExclude);
    }

    private String getActionText() {
        return this.myIsExclude ? "Exclude" : "Include";
    }
}

