/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SearchEverywhereContributor<F> {
    public static final ExtensionPointName<SearchEverywhereContributorFactory<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.searchEverywhereContributor");

    @NotNull
    public String getSearchProviderId();

    @NotNull
    public String getGroupName();

    @NotNull
    default public String getFullGroupName() {
        return this.getGroupName();
    }

    @Nullable
    public String includeNonProjectItemsText();

    public int getSortWeight();

    public boolean showInFindResults();

    default public boolean isShownInSeparateTab() {
        return false;
    }

    default public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        return 0;
    }

    @NotNull
    default public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        return Collections.emptyList();
    }

    @Nullable
    default public String getAdvertisement() {
        return null;
    }

    public void fetchElements(@NotNull String var1, boolean var2, @Nullable SearchEverywhereContributorFilter<F> var3, @NotNull ProgressIndicator var4, @NotNull Function<Object, Boolean> var5);

    @NotNull
    default public ContributorSearchResult<Object> search(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<F> filter, @NotNull ProgressIndicator progressIndicator, int elementsLimit) {
        ContributorSearchResult.Builder builder = ContributorSearchResult.builder();
        this.fetchElements(pattern, everywhere, filter, progressIndicator, element -> {
            if (elementsLimit < 0 || builder.itemsCount() < elementsLimit) {
                builder.addItem(element);
                return true;
            }
            builder.setHasMore(true);
            return false;
        });
        return builder.build();
    }

    @NotNull
    default public List<Object> search(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<F> filter, @NotNull ProgressIndicator progressIndicator) {
        ArrayList<Object> res = new ArrayList<Object>();
        this.fetchElements(pattern, everywhere, filter, progressIndicator, o -> res.add(o));
        return res;
    }

    public boolean processSelectedItem(@NotNull Object var1, int var2, @NotNull String var3);

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> var1);

    @Nullable
    public Object getDataForItem(@NotNull Object var1, @NotNull String var2);

    @NotNull
    default public String filterControlSymbols(@NotNull String pattern) {
        return pattern;
    }

    default public boolean isMultiselectSupported() {
        return false;
    }

    default public boolean isDumbModeSupported() {
        return true;
    }

    default public boolean isEmptyPatternSupported() {
        return false;
    }

    @NotNull
    public static List<SearchEverywhereContributorFactory<?>> getProviders() {
        return Arrays.asList(EP_NAME.getExtensions());
    }
}

