/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class WebBrowserService {
    public static WebBrowserService getInstance() {
        return ServiceManager.getService(WebBrowserService.class);
    }

    @NotNull
    public abstract Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest var1, boolean var2) throws WebBrowserUrlProvider.BrowserException;

    public static boolean isHtmlOrXmlLanguage(@NotNull Language language) {
        return language.isKindOf(HTMLLanguage.INSTANCE) || language == XHTMLLanguage.INSTANCE || language == XMLLanguage.INSTANCE;
    }

    public static boolean isHtmlOrXmlFile(@NotNull PsiFile psiFile) {
        Language baseLanguage = psiFile.getViewProvider().getBaseLanguage();
        if (WebBrowserService.isHtmlOrXmlLanguage(baseLanguage)) {
            return true;
        }
        if (psiFile.getFileType() instanceof LanguageFileType) {
            return WebBrowserService.isHtmlOrXmlLanguage(((LanguageFileType)psiFile.getFileType()).getLanguage());
        }
        return false;
    }
}

