/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.chrome;

import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ChromeSettingsConfigurable
implements Configurable {
    private final ChromeSettings mySettings;
    private JPanel myMainPanel;
    private JCheckBox myUseCustomProfileCheckBox;
    private TextFieldWithBrowseButton myUserDataDirField;
    private JLabel myCommandLineOptionsLabel;
    private RawCommandLineEditor myCommandLineOptionsEditor;
    private final String myDefaultUserDirPath;

    public ChromeSettingsConfigurable(@NotNull ChromeSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myUserDataDirField.addBrowseFolderListener("Select User Data Directory", "Specifies the directory that user data (your \"profile\") is kept in", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myUseCustomProfileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromeSettingsConfigurable.this.myUserDataDirField.setEnabled(ChromeSettingsConfigurable.this.myUseCustomProfileCheckBox.isSelected());
            }
        });
        this.myDefaultUserDirPath = ChromeSettingsConfigurable.getDefaultUserDataPath();
        this.myCommandLineOptionsEditor.setDialogCaption("Chrome Command Line Options");
        this.myCommandLineOptionsLabel.setLabelFor(this.myCommandLineOptionsEditor.getTextField());
    }

    @Override
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    @Override
    public boolean isModified() {
        if (this.myUseCustomProfileCheckBox.isSelected() != this.mySettings.isUseCustomProfile() || !this.myCommandLineOptionsEditor.getText().equals(StringUtil.notNullize((String)this.mySettings.getCommandLineOptions()))) {
            return true;
        }
        String configuredPath = this.getConfiguredUserDataDirPath();
        String storedPath = this.mySettings.getUserDataDirectoryPath();
        if (this.myDefaultUserDirPath.equals(configuredPath) && storedPath == null) {
            return false;
        }
        return !configuredPath.equals(storedPath);
    }

    private String getConfiguredUserDataDirPath() {
        return FileUtil.toSystemIndependentName((String)this.myUserDataDirField.getText());
    }

    @Override
    public void apply() throws ConfigurationException {
        this.mySettings.setCommandLineOptions(this.myCommandLineOptionsEditor.getText());
        this.mySettings.setUseCustomProfile(this.myUseCustomProfileCheckBox.isSelected());
        this.mySettings.setUserDataDirectoryPath(this.getConfiguredUserDataDirPath());
    }

    @Override
    public void reset() {
        this.myCommandLineOptionsEditor.setText(this.mySettings.getCommandLineOptions());
        this.myUseCustomProfileCheckBox.setSelected(this.mySettings.isUseCustomProfile());
        this.myUserDataDirField.setEnabled(this.mySettings.isUseCustomProfile());
        String path2 = this.mySettings.getUserDataDirectoryPath();
        if (path2 != null) {
            this.myUserDataDirField.setText(FileUtil.toSystemDependentName((String)path2));
        } else {
            this.myUserDataDirField.setText(FileUtil.toSystemDependentName((String)this.myDefaultUserDirPath));
        }
    }

    public void enableRecommendedOptions() {
        if (!this.myUseCustomProfileCheckBox.isSelected()) {
            this.myUseCustomProfileCheckBox.doClick(0);
        }
    }

    private static String getDefaultUserDataPath() {
        File dir = new File(PathManager.getConfigPath(), "chrome-user-data");
        try {
            return FileUtil.toSystemIndependentName((String)dir.getCanonicalPath());
        }
        catch (IOException e) {
            return FileUtil.toSystemIndependentName((String)dir.getAbsolutePath());
        }
    }

    @Override
    @Nls
    public String getDisplayName() {
        return "Chrome Settings";
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseCustomProfileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use custom user data directory:");
        jCheckBox.setMnemonic('U');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUserDataDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null, 2));
        this.myCommandLineOptionsEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null, 2));
        this.myCommandLineOptionsLabel = jLabel = new JLabel();
        jLabel.setText("Command line options:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

