/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.IdeBundle;
import org.jetbrains.annotations.NotNull;

public enum ErrorTreeElementKind {
    INFO("INFO", IdeBundle.message("errortree.information", new Object[0])),
    ERROR("ERROR", IdeBundle.message("errortree.error", new Object[0])),
    WARNING("WARNING", IdeBundle.message("errortree.warning", new Object[0])),
    NOTE("NOTE", IdeBundle.message("errortree.note", new Object[0])),
    GENERIC("GENERIC", "");

    private final String myText;
    private final String myPresentableText;

    private ErrorTreeElementKind(String text, String presentableText) {
        this.myText = text;
        this.myPresentableText = presentableText;
    }

    public String toString() {
        return this.myText;
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    @NotNull
    public static ErrorTreeElementKind convertMessageFromCompilerErrorType(int type) {
        switch (type) {
            case 4: {
                return ERROR;
            }
            case 5: {
                return WARNING;
            }
            case 3: {
                return INFO;
            }
            case 2: {
                return INFO;
            }
            case 1: {
                return GENERIC;
            }
            case 6: {
                return NOTE;
            }
        }
        return GENERIC;
    }
}

