/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorBasedStructureViewModel
implements StructureViewModel,
ProvidingTreeModel {
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final List<FileEditorPositionListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ModelListener> myModelListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final CaretListener myEditorCaretListener;
    private Disposable myEditorCaretListenerDisposable;

    protected TextEditorBasedStructureViewModel(@NotNull PsiFile psiFile) {
        this(PsiEditorUtil.Service.getInstance().findEditorByPsiElement(psiFile), psiFile);
    }

    protected TextEditorBasedStructureViewModel(Editor editor) {
        this(editor, null);
    }

    protected TextEditorBasedStructureViewModel(Editor editor, PsiFile file) {
        this.myEditor = editor;
        this.myPsiFile = file;
        this.myEditorCaretListener = new CaretListener(){

            @Override
            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e.getEditor().equals(TextEditorBasedStructureViewModel.this.myEditor)) {
                    for (FileEditorPositionListener listener : TextEditorBasedStructureViewModel.this.myListeners) {
                        listener.onCurrentElementChanged();
                    }
                }
            }
        };
    }

    @Override
    public final void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            this.myEditorCaretListenerDisposable = Disposer.newDisposable();
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(this.myEditorCaretListener, this.myEditorCaretListenerDisposable);
        }
        this.myListeners.add(listener);
    }

    @Override
    public final void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        this.myListeners.remove(listener);
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            Disposer.dispose((Disposable)this.myEditorCaretListenerDisposable);
            this.myEditorCaretListenerDisposable = null;
        }
    }

    @Override
    public void dispose() {
        if (this.myEditorCaretListenerDisposable != null) {
            Disposer.dispose((Disposable)this.myEditorCaretListenerDisposable);
        }
        this.myModelListeners.clear();
    }

    public void fireModelUpdate() {
        for (ModelListener listener : this.myModelListeners) {
            listener.onModelChanged();
        }
    }

    @Override
    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @Override
    public Object getCurrentEditorElement() {
        Object o2;
        if (this.myEditor == null) {
            return null;
        }
        PsiFile file = this.getPsiFile();
        if (!file.isValid()) {
            return null;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        Object o1 = this.findAcceptableElement(file.getViewProvider().findElementAt(offset, file.getLanguage()));
        Object object = o2 = offset == 0 ? o1 : this.findAcceptableElement(file.getViewProvider().findElementAt(offset - 1, file.getLanguage()));
        if (o1 != o2 && o1 instanceof PsiElement && o2 instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)o1, (PsiElement)o2, false)) {
            return o2;
        }
        return o1;
    }

    @Nullable
    protected Object findAcceptableElement(PsiElement element) {
        while (element != null && !(element instanceof PsiFile)) {
            if (this.isSuitable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    protected boolean isSuitable(PsiElement element) {
        Class[] suitableClasses;
        if (element == null) {
            return false;
        }
        for (Class suitableClass : suitableClasses = this.getSuitableClasses()) {
            if (!ReflectionUtil.isAssignable((Class)suitableClass, element.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addModelListener(@NotNull ModelListener modelListener) {
        this.myModelListeners.add(modelListener);
    }

    @Override
    public void removeModelListener(@NotNull ModelListener modelListener) {
        this.myModelListeners.remove(modelListener);
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Grouper[] getGroupers() {
        return Grouper.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Sorter[] getSorters() {
        return Sorter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Filter[] getFilters() {
        return Filter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled(@NotNull NodeProvider provider) {
        return false;
    }
}

