/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import org.jetbrains.annotations.NotNull;

public enum AntialiasingType {
    SUBPIXEL("Subpixel", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, true),
    GREYSCALE("Greyscale", RenderingHints.VALUE_TEXT_ANTIALIAS_ON, true),
    OFF("No antialiasing", RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, false);

    private final String myName;
    private final Object myHint;
    private final boolean isEnabled;

    public static Object getAAHintForSwingComponent() {
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if (uiSettings != null) {
            AntialiasingType type = uiSettings.getIdeAAType();
            return type.getTextInfo();
        }
        return GREYSCALE.getTextInfo();
    }

    public static Object getKeyForCurrentScope(boolean inEditor) {
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if (uiSettings != null) {
            AntialiasingType type = inEditor ? uiSettings.getEditorAAType() : uiSettings.getIdeAAType();
            return type.myHint;
        }
        return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    }

    public static FontRenderContext updateContext(@NotNull FontRenderContext context, boolean inEditor) {
        Object aaHint = AntialiasingType.getKeyForCurrentScope(inEditor);
        return aaHint == context.getAntiAliasingHint() ? context : new FontRenderContext(context.getTransform(), aaHint, context.getFractionalMetricsHint());
    }

    private AntialiasingType(String name, Object hint, boolean enabled) {
        this.myName = name;
        this.myHint = hint;
        this.isEnabled = enabled;
    }

    public Object getTextInfo() {
        return this.isEnabled || SystemInfo.isJetBrainsJvm ? GraphicsUtil.createAATextInfo((Object)this.myHint) : null;
    }

    public String toString() {
        return this.myName;
    }
}

