/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Tag(value="splitter-proportions")
public class SplitterProportionsDataImpl
implements SplitterProportionsData {
    private static final String DATA_VERSION = "1";
    @NonNls
    private static final String ATTRIBUTE_PROPORTIONS = "proportions";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    private List<Float> proportions = new SmartList();

    @Override
    public void saveSplitterProportions(Component root) {
        this.proportions.clear();
        this.doSaveSplitterProportions(root);
    }

    private void doSaveSplitterProportions(Component root) {
        if (root instanceof Splitter) {
            Float prop = Float.valueOf(((Splitter)root).getProportion());
            this.proportions.add(prop);
        }
        if (root instanceof Container) {
            for (Component child : ((Container)root).getComponents()) {
                this.doSaveSplitterProportions(child);
            }
        }
    }

    @Override
    public void restoreSplitterProportions(Component root) {
        this.restoreSplitterProportions(root, 0);
    }

    private int restoreSplitterProportions(Component root, int index2) {
        if (root instanceof Splitter) {
            if (this.proportions.size() <= index2) {
                return index2;
            }
            ((Splitter)root).setProportion(this.proportions.get(index2++).floatValue());
        }
        if (root instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)root).getComponents()) {
                index2 = this.restoreSplitterProportions(child, index2);
            }
        }
        return index2;
    }

    @Override
    public void externalizeToDimensionService(String key) {
        for (int i = 0; i < this.proportions.size(); ++i) {
            PropertiesComponent.getInstance().setValue(key + "." + i, (int)(this.proportions.get(i).floatValue() * 1000.0f), -1);
        }
    }

    @Override
    public void externalizeFromDimensionService(String key) {
        int value;
        this.proportions.clear();
        int i = 0;
        while ((value = PropertiesComponent.getInstance().getInt(key + "." + i, -1)) != -1) {
            this.proportions.add(new Float((double)value * 0.001));
            ++i;
        }
    }

    public void readExternal(Element element) {
        this.proportions.clear();
        String prop = element.getAttributeValue(ATTRIBUTE_PROPORTIONS);
        String version = element.getAttributeValue(ATTRIBUTE_VERSION);
        if (prop != null && Comparing.equal((String)version, (String)DATA_VERSION)) {
            StringTokenizer tokenizer = new StringTokenizer(prop, ",");
            while (tokenizer.hasMoreTokens()) {
                String p = tokenizer.nextToken();
                this.proportions.add(Float.valueOf(p));
            }
        }
    }

    public void writeExternal(Element element) {
        StringBuilder result2 = new StringBuilder();
        String sep = "";
        for (Float proportion : this.proportions) {
            result2.append(sep);
            result2.append(proportion);
            sep = ",";
        }
        element.setAttribute(ATTRIBUTE_PROPORTIONS, result2.toString());
        element.setAttribute(ATTRIBUTE_VERSION, DATA_VERSION);
    }

    public List<Float> getProportions() {
        return this.proportions;
    }

    public void setProportions(List<Float> proportions) {
        this.proportions = proportions;
    }

    public boolean equals(Object obj) {
        return obj instanceof SplitterProportionsDataImpl && ((SplitterProportionsDataImpl)obj).getProportions().equals(this.proportions);
    }

    public static final class SplitterProportionsConverter
    extends Converter<SplitterProportionsDataImpl> {
        @NotNull
        public SplitterProportionsDataImpl fromString(@NotNull String value) {
            SplitterProportionsDataImpl data = new SplitterProportionsDataImpl();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                data.proportions.add(Float.valueOf(tokenizer.nextToken()));
            }
            return data;
        }

        @NotNull
        public String toString(@NotNull SplitterProportionsDataImpl data) {
            StringBuilder result2 = new StringBuilder();
            String sep = "";
            for (Float proportion : data.proportions) {
                result2.append(sep);
                result2.append(proportion);
                sep = ",";
            }
            return result2.toString();
        }
    }
}

