/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportConfigurableBase
extends FrameworkSupportConfigurable {
    private JComboBox myVersionComboBox;
    private final FrameworkSupportProviderBase myFrameworkSupportProvider;
    protected final FrameworkSupportModel myFrameworkSupportModel;
    private final List<FrameworkVersion> myVersions;
    private JPanel myMainPanel;
    private JLabel myDescriptionLabel;

    public FrameworkSupportConfigurableBase(FrameworkSupportProviderBase frameworkSupportProvider, FrameworkSupportModel model) {
        this(frameworkSupportProvider, model, Collections.emptyList(), null);
    }

    public FrameworkSupportConfigurableBase(FrameworkSupportProviderBase frameworkSupportProvider, FrameworkSupportModel model, @NotNull List<FrameworkVersion> versions, @Nullable String versionLabelText) {
        this.myFrameworkSupportProvider = frameworkSupportProvider;
        this.myFrameworkSupportModel = model;
        this.myVersions = versions;
        this.$$$setupUI$$$();
        this.myDescriptionLabel.setText(versionLabelText);
        this.myVersionComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index2, boolean selected, boolean hasFocus) {
                if (value instanceof FrameworkVersion) {
                    this.setText(((FrameworkVersion)value).getVersionName());
                }
            }
        });
        this.updateAvailableVersions(versions);
        this.myVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameworkSupportConfigurableBase.this.fireFrameworkVersionChanged();
            }
        });
    }

    protected void updateAvailableVersions(List<? extends FrameworkVersion> versions) {
        if (versions.size() > 0) {
            String maxValue = "";
            ((DefaultComboBoxModel)this.myVersionComboBox.getModel()).removeAllElements();
            FrameworkVersion defaultVersion = versions.get(versions.size() - 1);
            for (FrameworkVersion frameworkVersion : versions) {
                this.myVersionComboBox.addItem(frameworkVersion);
                FontMetrics fontMetrics = this.myVersionComboBox.getFontMetrics(this.myVersionComboBox.getFont());
                if (fontMetrics.stringWidth(frameworkVersion.getVersionName()) > fontMetrics.stringWidth(maxValue)) {
                    maxValue = frameworkVersion.getVersionName();
                }
                if (!frameworkVersion.isDefault()) continue;
                defaultVersion = frameworkVersion;
            }
            this.myVersionComboBox.setSelectedItem(defaultVersion);
            this.myVersionComboBox.setPrototypeDisplayValue(maxValue + "_");
        }
        boolean hasMoreThanOneVersion = versions.size() >= 2;
        this.myDescriptionLabel.setVisible(hasMoreThanOneVersion);
        this.myVersionComboBox.setVisible(hasMoreThanOneVersion);
    }

    @Override
    public JComponent getComponent() {
        return this.myMainPanel;
    }

    protected void reloadVersions(List<? extends FrameworkVersion> frameworkVersions) {
        this.myVersions.clear();
        this.myVersions.addAll(frameworkVersions);
    }

    @Override
    @NotNull
    public List<? extends FrameworkVersion> getVersions() {
        return this.myVersions;
    }

    @NotNull
    public LibraryInfo[] getLibraries() {
        return this.getSelectedVersion().getLibraries();
    }

    @Override
    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
        this.myFrameworkSupportProvider.addSupport(module, rootModel, this.getSelectedVersion(), library);
    }

    @Override
    public FrameworkVersion getSelectedVersion() {
        return (FrameworkVersion)this.myVersionComboBox.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 2, -1, false, false));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Version:");
        jLabel.setDisplayedMnemonic('V');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myVersionComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

