/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.tree.LeafState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructure {
    @NotNull
    public abstract Object getRootElement();

    @NotNull
    public abstract Object[] getChildElements(@NotNull Object var1);

    @Nullable
    public abstract Object getParentElement(@NotNull Object var1);

    @NotNull
    public abstract NodeDescriptor createDescriptor(@NotNull Object var1, @Nullable NodeDescriptor var2);

    public abstract void commit();

    public abstract boolean hasSomethingToCommit();

    @NotNull
    public static ActionCallback asyncCommitDocuments(@NotNull Project project) {
        if (project.isDisposed()) {
            return ActionCallback.DONE;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        if (!documentManager.hasUncommitedDocuments()) {
            return ActionCallback.DONE;
        }
        ActionCallback callback = new ActionCallback();
        documentManager.performWhenAllCommitted(callback.createSetDoneRunnable());
        return callback;
    }

    @NotNull
    public ActionCallback asyncCommit() {
        if (this.hasSomethingToCommit()) {
            this.commit();
        }
        return ActionCallback.DONE;
    }

    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        return false;
    }

    public boolean isValid(@NotNull Object element) {
        return true;
    }

    @NotNull
    public LeafState getLeafState(@NotNull Object element) {
        if (this.isAlwaysLeaf(element)) {
            return LeafState.ALWAYS;
        }
        if (element instanceof LeafState.Supplier) {
            LeafState.Supplier supplier = (LeafState.Supplier)element;
            return supplier.getLeafState();
        }
        return LeafState.DEFAULT;
    }

    public boolean isAlwaysLeaf(@NotNull Object element) {
        return false;
    }

    @NotNull
    public AsyncResult<Object> revalidateElement(@NotNull Object element) {
        return AsyncResult.done(element);
    }
}

