/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class TreeState
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(TreeState.class);
    public static final Key<WeakReference<ActionCallback>> CALLBACK = Key.create((String)"Callback");
    private static final Key<Promise<Void>> EXPANDING = Key.create((String)"TreeExpanding");
    private static final String EXPAND_TAG = "expand";
    private static final String SELECT_TAG = "select";
    private static final String PATH_TAG = "path";
    private final List<List<PathElement>> myExpandedPaths;
    private final List<List<PathElement>> mySelectedPaths;
    private boolean myScrollToSelection;

    private TreeState(List<List<PathElement>> expandedPaths, List<List<PathElement>> selectedPaths) {
        this.myExpandedPaths = expandedPaths;
        this.mySelectedPaths = selectedPaths;
        this.myScrollToSelection = true;
    }

    public boolean isEmpty() {
        return this.myExpandedPaths.isEmpty() && this.mySelectedPaths.isEmpty();
    }

    public void readExternal(Element element) throws InvalidDataException {
        TreeState.readExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.readExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void readExternal(Element root, List<? super List<PathElement>> list, String name) throws InvalidDataException {
        list.clear();
        for (Element element : root.getChildren(name)) {
            for (Element child : element.getChildren(PATH_TAG)) {
                Object[] path2 = (PathElement[])XmlSerializer.deserialize((Element)child, PathElement[].class);
                list.add((List<PathElement>)ContainerUtil.immutableList((Object[])path2));
            }
        }
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull DefaultMutableTreeNode treeNode) {
        return TreeState.createOn(tree, new TreePath(treeNode.getPath()));
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree, @NotNull TreePath rootPath) {
        return new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree, rootPath)), TreeState.createPaths(tree, TreeUtil.collectSelectedPaths(tree, rootPath)));
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree) {
        return new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree)), new ArrayList<List<PathElement>>());
    }

    @NotNull
    public static TreeState createFrom(@Nullable Element element) {
        TreeState state = new TreeState(new ArrayList<List<PathElement>>(), new ArrayList<List<PathElement>>());
        try {
            if (element != null) {
                state.readExternal(element);
            }
        }
        catch (InvalidDataException e) {
            LOG.warn((Throwable)e);
        }
        return state;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeState.writeExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.writeExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void writeExternal(Element element, List<? extends List<PathElement>> list, String name) throws WriteExternalException {
        Element root = new Element(name);
        for (List<PathElement> list2 : list) {
            Element e = XmlSerializer.serialize((Object)list2.toArray());
            e.setName(PATH_TAG);
            root.addContent(e);
        }
        element.addContent(root);
    }

    @NotNull
    private static List<List<PathElement>> createPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        return JBIterable.from(paths).filter(o -> o.getPathCount() > 1 || tree.isRootVisible()).map(o -> TreeState.createPath(tree.getModel(), o)).toList();
    }

    @NotNull
    private static List<PathElement> createPath(@NotNull TreeModel model, @NotNull TreePath treePath) {
        Object prev = null;
        int count = treePath.getPathCount();
        PathElement[] result2 = new PathElement[count];
        for (int i = 0; i < count; ++i) {
            Object cur = treePath.getPathComponent(i);
            Object userObject = TreeUtil.getUserObject(cur);
            int childIndex = prev == null ? 0 : model.getIndexOfChild(prev, cur);
            result2[i] = new PathElement(TreeState.calcId(userObject), TreeState.calcType(userObject), childIndex, userObject);
            prev = cur;
        }
        return Arrays.asList(result2);
    }

    @NotNull
    private static String calcId(@Nullable Object userObject) {
        Object value;
        if (userObject == null) {
            return "";
        }
        Object object = userObject instanceof NodeDescriptorProvidingKey ? ((NodeDescriptorProvidingKey)userObject).getKey() : (value = userObject instanceof AbstractTreeNode ? ((AbstractTreeNode)userObject).getValue() : userObject);
        if (value instanceof NavigationItem) {
            try {
                String name = ((NavigationItem)value).getName();
                return name != null ? name : StringUtil.notNullize((String)value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StringUtil.notNullize((String)userObject.toString());
    }

    @NotNull
    private static String calcType(@Nullable Object userObject) {
        if (userObject == null) {
            return "";
        }
        String name = userObject.getClass().getName();
        return Integer.toHexString(StringHash.murmur((String)name, (int)31)) + ":" + StringUtil.getShortName((String)name);
    }

    public void applyTo(@NotNull JTree tree) {
        this.applyTo(tree, tree.getModel().getRoot());
    }

    public void applyTo(final @NotNull JTree tree, final @Nullable Object root) {
        LOG.debug((Throwable)new IllegalStateException("restore paths"));
        if (this.visit(tree)) {
            return;
        }
        if (root == null) {
            return;
        }
        final TreeFacade facade = TreeFacade.getFacade(tree);
        ActionCallback callback = facade.getInitialized().doWhenDone(new TreeRunnable("TreeState.applyTo: on done facade init"){

            @Override
            public void perform() {
                facade.batch(indicator -> TreeState.this.applyExpandedTo(facade, new TreePath(root), indicator));
            }
        });
        if (tree.getSelectionCount() == 0) {
            callback.doWhenDone(new TreeRunnable("TreeState.applyTo: on done"){

                @Override
                public void perform() {
                    if (tree.getSelectionCount() == 0) {
                        TreeState.this.applySelectedTo(tree);
                    }
                }
            });
        }
    }

    private void applyExpandedTo(@NotNull TreeFacade tree, @NotNull TreePath rootPath, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        if (rootPath.getPathCount() <= 0) {
            return;
        }
        for (List<PathElement> path2 : this.myExpandedPaths) {
            int index2;
            if (path2.isEmpty() || !path2.get(index2 = rootPath.getPathCount() - 1).isMatchTo(rootPath.getPathComponent(index2))) continue;
            TreeState.expandImpl(0, path2, rootPath, tree, indicator);
        }
    }

    private void applySelectedTo(@NotNull JTree tree) {
        ArrayList selection = new ArrayList();
        for (List<PathElement> path2 : this.mySelectedPaths) {
            TreeModel model = tree.getModel();
            TreePath treePath = new TreePath(model.getRoot());
            for (int i = 1; treePath != null && i < path2.size(); ++i) {
                treePath = TreeState.findMatchedChild(model, treePath, path2.get(i));
            }
            ContainerUtil.addIfNotNull(selection, (Object)treePath);
        }
        if (selection.isEmpty()) {
            return;
        }
        for (TreePath treePath : selection) {
            tree.setSelectionPath(treePath);
        }
        if (this.myScrollToSelection) {
            TreeUtil.showRowCentered(tree, tree.getRowForPath((TreePath)selection.get(0)), true, true);
        }
    }

    @Nullable
    private static TreePath findMatchedChild(@NotNull TreeModel model, @NotNull TreePath treePath, @NotNull PathElement pathElement) {
        Object child;
        Object parent = treePath.getLastPathComponent();
        int childCount = model.getChildCount(parent);
        if (childCount <= 0) {
            return null;
        }
        boolean idMatchedFound = false;
        Object idMatchedChild = null;
        for (int j = 0; j < childCount; ++j) {
            child = model.getChild(parent, j);
            Match match = pathElement.getMatchTo(child);
            if (match == Match.OBJECT) {
                return treePath.pathByAddingChild(child);
            }
            if (match != Match.ID_TYPE || idMatchedFound) continue;
            idMatchedChild = child;
            idMatchedFound = true;
        }
        if (idMatchedFound) {
            return treePath.pathByAddingChild(idMatchedChild);
        }
        int index2 = Math.max(0, Math.min(pathElement.index, childCount - 1));
        child = model.getChild(parent, index2);
        return treePath.pathByAddingChild(child);
    }

    private static void expandImpl(final int positionInPath, final List<? extends PathElement> path2, final TreePath treePath, final TreeFacade tree, final ProgressIndicator indicator) {
        tree.expand(treePath).doWhenDone(new TreeRunnable("TreeState.applyTo"){

            @Override
            public void perform() {
                PathElement next;
                indicator.checkCanceled();
                PathElement pathElement = next = positionInPath == path2.size() - 1 ? null : (PathElement)path2.get(positionInPath + 1);
                if (next == null) {
                    return;
                }
                Object parent = treePath.getLastPathComponent();
                TreeModel model = tree.tree.getModel();
                int childCount = model.getChildCount(parent);
                for (int j = 0; j < childCount; ++j) {
                    Object child = tree.tree.getModel().getChild(parent, j);
                    if (!next.isMatchTo(child)) continue;
                    TreeState.expandImpl(positionInPath + 1, path2, treePath.pathByAddingChild(child), tree, indicator);
                    break;
                }
            }
        });
    }

    public void setScrollToSelection(boolean scrollToSelection) {
        this.myScrollToSelection = scrollToSelection;
    }

    public String toString() {
        String content;
        Element st = new Element("TreeState");
        try {
            this.writeExternal(st);
            content = JDOMUtil.writeChildren((Element)st, (String)"\n");
        }
        catch (IOException e) {
            content = ExceptionUtil.getThrowableText((Throwable)e);
        }
        return "TreeState(" + this.myScrollToSelection + ")\n" + content;
    }

    @Deprecated
    public static void expand(@NotNull JTree tree, @NotNull Consumer<? super AsyncPromise<Void>> consumer) {
        Promise<Void> expanding = (Promise<Void>)UIUtil.getClientProperty((Object)tree, EXPANDING);
        LOG.debug("EXPANDING: ", new Object[]{expanding});
        if (expanding == null) {
            expanding = Promises.resolvedPromise();
        }
        expanding.onProcessed(value -> {
            AsyncPromise promise = new AsyncPromise();
            UIUtil.putClientProperty((JComponent)tree, EXPANDING, promise);
            consumer.accept(promise);
        });
    }

    private static boolean isSelectionNeeded(List<TreePath> list, @NotNull JTree tree, AsyncPromise<Void> promise) {
        if (list != null && tree.isSelectionEmpty()) {
            return true;
        }
        if (promise != null) {
            promise.setResult(null);
        }
        return false;
    }

    private Promise<List<TreePath>> expand(@NotNull JTree tree) {
        return TreeUtil.promiseExpand(tree, this.myExpandedPaths.stream().map(elements -> new Visitor((List<PathElement>)elements)));
    }

    private Promise<List<TreePath>> select(@NotNull JTree tree) {
        return TreeUtil.promiseSelect(tree, this.mySelectedPaths.stream().map(elements -> new Visitor((List<PathElement>)elements)));
    }

    private boolean visit(@NotNull JTree tree) {
        TreeModel model = tree.getModel();
        if (!(model instanceof TreeVisitor.Acceptor)) {
            return false;
        }
        TreeState.expand(tree, promise -> this.expand(tree).onProcessed(expanded -> {
            if (TreeState.isSelectionNeeded(expanded, tree, promise)) {
                this.select(tree).onProcessed(selected -> promise.setResult(null));
            }
        }));
        return true;
    }

    private static final class Visitor
    implements TreeVisitor {
        private final List<PathElement> elements;

        Visitor(List<PathElement> elements) {
            this.elements = elements;
        }

        @Override
        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path2) {
            int count = path2.getPathCount();
            if (count > this.elements.size()) {
                return TreeVisitor.Action.SKIP_CHILDREN;
            }
            boolean matches = this.elements.get(count - 1).isMatchTo(path2.getLastPathComponent());
            return !matches ? TreeVisitor.Action.SKIP_CHILDREN : (count < this.elements.size() ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT);
        }
    }

    static class BuilderFacade
    extends TreeFacade {
        private final AbstractTreeBuilder myBuilder;

        BuilderFacade(AbstractTreeBuilder builder) {
            super((JTree)ObjectUtils.notNull((Object)builder.getTree()));
            this.myBuilder = builder;
        }

        @Override
        public ActionCallback getInitialized() {
            return this.myBuilder.getReady(this);
        }

        @Override
        public void batch(Progressive progressive) {
            this.myBuilder.batch(progressive);
        }

        @Override
        public ActionCallback expand(TreePath treePath) {
            NodeDescriptor desc = TreeUtil.getLastUserObject(NodeDescriptor.class, treePath);
            if (desc == null) {
                return ActionCallback.REJECTED;
            }
            Object element = this.myBuilder.getTreeStructureElement(desc);
            ActionCallback result2 = new ActionCallback();
            this.myBuilder.expand(element, result2.createSetDoneRunnable());
            return result2;
        }
    }

    static class JTreeFacade
    extends TreeFacade {
        JTreeFacade(JTree tree) {
            super(tree);
        }

        @Override
        public ActionCallback expand(@NotNull TreePath treePath) {
            this.tree.expandPath(treePath);
            return ActionCallback.DONE;
        }

        @Override
        public ActionCallback getInitialized() {
            WeakReference ref = (WeakReference)UIUtil.getClientProperty((Object)this.tree, CALLBACK);
            ActionCallback callback = (ActionCallback)SoftReference.dereference((Reference)ref);
            if (callback != null) {
                return callback;
            }
            return ActionCallback.DONE;
        }

        @Override
        public void batch(Progressive progressive) {
            progressive.run(new EmptyProgressIndicator());
        }
    }

    static abstract class TreeFacade {
        final JTree tree;

        TreeFacade(@NotNull JTree tree) {
            this.tree = tree;
        }

        abstract ActionCallback getInitialized();

        abstract ActionCallback expand(TreePath var1);

        abstract void batch(Progressive var1);

        static TreeFacade getFacade(JTree tree) {
            AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
            return builder != null ? new BuilderFacade(builder) : new JTreeFacade(tree);
        }
    }

    @Tag(value="item")
    static class PathElement {
        @Attribute(value="name")
        public String id;
        @Attribute(value="type")
        public String type;
        @Attribute(value="user")
        public String userStr;
        Object userObject;
        final int index;

        PathElement() {
            this(null, null, -1, null);
        }

        PathElement(String itemId, String itemType, int itemIndex, Object userObject) {
            this.id = itemId;
            this.type = itemType;
            this.index = itemIndex;
            this.userStr = userObject instanceof String ? (String)userObject : null;
            this.userObject = userObject;
        }

        public String toString() {
            return this.id + ": " + this.type;
        }

        private boolean isMatchTo(Object object) {
            return this.getMatchTo(object) != null;
        }

        private Match getMatchTo(Object object) {
            Object userObject = TreeUtil.getUserObject(object);
            if (this.userObject != null && this.userObject.equals(userObject)) {
                return Match.OBJECT;
            }
            return Comparing.equal((String)this.id, (String)TreeState.calcId(userObject)) && Comparing.equal((String)this.type, (String)TreeState.calcType(userObject)) ? Match.ID_TYPE : null;
        }
    }

    private static enum Match {
        OBJECT,
        ID_TYPE;

    }
}

