/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        this(epName, defaultImplementation, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation, @Nullable Disposable parentDisposable) {
        super(epName, parentDisposable);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create((String)("EXTENSIONS_IN_LANGUAGE_" + epName));
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        return key.getID();
    }

    public T forLanguage(@NotNull Language l) {
        Object cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return (T)cached;
        }
        Object result2 = this.findForLanguage(l);
        if (result2 == null) {
            return null;
        }
        result2 = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result2);
        return result2;
    }

    protected T findForLanguage(@NotNull Language language) {
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List extensions = this.forKey(l);
            if (extensions.isEmpty()) continue;
            return extensions.get(0);
        }
        return this.myDefaultImplementation;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        boolean copyList = true;
        ArrayList result2 = null;
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            ArrayList list = this.forKey(l);
            if (result2 == null) {
                result2 = list;
                continue;
            }
            if (list.isEmpty()) continue;
            if (copyList) {
                result2 = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat(result2, list));
                copyList = false;
                continue;
            }
            result2.addAll(list);
        }
        return result2;
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        Collection<MetaLanguage> metaLanguages = LanguageUtil.matchingMetaLanguages(key);
        if (metaLanguages.isEmpty()) {
            return super.buildExtensions(stringKey, key);
        }
        THashSet allKeys = new THashSet();
        allKeys.add(stringKey);
        for (MetaLanguage language : metaLanguages) {
            allKeys.add(this.keyToString(language));
        }
        return this.buildExtensions((Set<String>)allKeys);
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        List<T> forLanguage = this.allForLanguage(l);
        if (l == Language.ANY) {
            return forLanguage;
        }
        return ContainerUtil.concat(forLanguage, this.allForLanguage(Language.ANY));
    }

    @Override
    public void addExplicitExtension(@NotNull Language key, @NotNull T t) {
        key.putUserData(this.IN_LANGUAGE_CACHE, null);
        super.addExplicitExtension(key, t);
    }

    @Override
    public void removeExplicitExtension(@NotNull Language key, @NotNull T t) {
        key.putUserData(this.IN_LANGUAGE_CACHE, null);
        super.removeExplicitExtension(key, t);
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @Override
    protected void ensureValuesLoaded() {
        super.ensureValuesLoaded();
    }
}

