/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class MetaLanguage
extends Language {
    public static final ExtensionPointName<MetaLanguage> EP_NAME = ExtensionPointName.create((String)"com.intellij.metaLanguage");

    protected MetaLanguage(@NotNull String ID2) {
        super(ID2);
    }

    @NotNull
    public static List<MetaLanguage> all() {
        return EP_NAME.getExtensionList();
    }

    @NotNull
    public static Stream<MetaLanguage> getAllMatchingMetaLanguages(@NotNull Language language) {
        if (language instanceof MetaLanguage) {
            return Stream.empty();
        }
        return MetaLanguage.all().stream().filter(l -> l.matchesLanguage(language));
    }

    public abstract boolean matchesLanguage(@NotNull Language var1);

    @NotNull
    public Collection<Language> getMatchingLanguages() {
        return ContainerUtil.filter(Language.getRegisteredLanguages(), language -> this.matchesLanguage((Language)((Object)language)));
    }
}

