/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.findUsages;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.EmptyFindUsagesProvider;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageFindUsages
extends LanguageExtension<FindUsagesProvider> {
    public static final LanguageFindUsages INSTANCE = new LanguageFindUsages(){

        @Override
        @NotNull
        public List<FindUsagesProvider> allForLanguage(@NotNull Language language) {
            List<FindUsagesProvider> result2 = super.allForLanguage(language);
            if (result2.isEmpty()) {
                return Collections.singletonList(this.getDefaultImplementation());
            }
            return result2;
        }
    };

    private LanguageFindUsages() {
        super("com.intellij.lang.findUsagesProvider", new EmptyFindUsagesProvider());
    }

    public static boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        return LanguageFindUsages.getFromProviders(psiElement, Boolean.FALSE, p -> p.canFindUsagesFor(psiElement));
    }

    @Nullable
    public static WordsScanner getWordsScanner(@NotNull Language language) {
        for (FindUsagesProvider provider : INSTANCE.allForLanguage(language)) {
            WordsScanner scanner = provider.getWordsScanner();
            if (scanner == null) continue;
            return scanner;
        }
        return null;
    }

    @NotNull
    public static String getDescriptiveName(@NotNull PsiElement psiElement) {
        return LanguageFindUsages.getFromProviders(psiElement, "", p -> p.getDescriptiveName(psiElement));
    }

    @NotNull
    public static String getType(@NotNull PsiElement psiElement) {
        return LanguageFindUsages.getFromProviders(psiElement, "", p -> p.getType(psiElement));
    }

    @NotNull
    public static String getNodeText(@NotNull PsiElement psiElement, boolean useFullName) {
        return LanguageFindUsages.getFromProviders(psiElement, "", p -> p.getNodeText(psiElement, useFullName));
    }

    @Nullable
    public static String getHelpId(@NotNull PsiElement psiElement) {
        return LanguageFindUsages.getFromProviders(psiElement, null, p -> p.getHelpId(psiElement));
    }

    private static <T> T getFromProviders(@NotNull PsiElement psiElement, T defaultValue, @NotNull Function<FindUsagesProvider, T> getter) {
        Language language = psiElement.getLanguage();
        List providers = INSTANCE.allForLanguage(language);
        assert (!providers.isEmpty()) : "Element: " + psiElement + ", language: " + (Object)((Object)language);
        for (FindUsagesProvider provider : providers) {
            T res = getter.apply(provider);
            if (res == null || res.equals(defaultValue)) continue;
            return res;
        }
        return defaultValue;
    }
}

