/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageFolding
extends LanguageExtension<FoldingBuilder> {
    public static final LanguageFolding INSTANCE = new LanguageFolding();
    private static final Logger LOG = Logger.getInstance(LanguageFolding.class);

    private LanguageFolding() {
        super("com.intellij.lang.foldingBuilder");
    }

    @Override
    public FoldingBuilder forLanguage(@NotNull Language l) {
        return (FoldingBuilder)super.forLanguage(l);
    }

    @Override
    protected FoldingBuilder findForLanguage(@NotNull Language l) {
        List<FoldingBuilder> extensions = this.allForLanguage(l);
        if (extensions.isEmpty()) {
            return null;
        }
        if (extensions.size() == 1) {
            return extensions.get(0);
        }
        return new CompositeFoldingBuilder(extensions);
    }

    @Override
    @NotNull
    public List<FoldingBuilder> allForLanguage(@NotNull Language language) {
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List<FoldingBuilder> extensions = this.forKey(l);
            if (extensions.isEmpty()) continue;
            return extensions;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static FoldingDescriptor[] buildFoldingDescriptors(@Nullable FoldingBuilder builder, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        try {
            if (!DumbService.isDumbAware(builder) && DumbService.getInstance(root.getProject()).isDumb()) {
                return FoldingDescriptor.EMPTY;
            }
            if (builder instanceof FoldingBuilderEx) {
                return ((FoldingBuilderEx)builder).buildFoldRegions(root, document, quick);
            }
            ASTNode astNode = root.getNode();
            if (astNode == null || builder == null) {
                return FoldingDescriptor.EMPTY;
            }
            return builder.buildFoldRegions(astNode, document);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return FoldingDescriptor.EMPTY;
        }
    }
}

