/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerPositionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexer
extends DelegateLexer {
    public static ThreadLocal<Boolean> ourDisableLayersFlag = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.LayeredLexer");
    private static final int IN_LAYER_STATE = 1024;
    private static final int IN_LAYER_LEXER_FINISHED_STATE = 2048;
    private int myState;
    private final Map<IElementType, Lexer> myStartTokenToLayerLexer = new HashMap<IElementType, Lexer>();
    private Lexer myCurrentLayerLexer;
    private IElementType myCurrentBaseTokenType;
    private int myLayerLeftPart = -1;
    private int myBaseTokenEnd = -1;
    private final HashSet<Lexer> mySelfStoppingLexers = new HashSet(1);
    private final HashMap<Lexer, IElementType[]> myStopTokens = new HashMap(1);

    public LayeredLexer(Lexer baseLexer) {
        super(baseLexer);
    }

    public void registerSelfStoppingLayer(Lexer lexer, IElementType[] startTokens, IElementType[] stopTokens) {
        if (Boolean.TRUE.equals(ourDisableLayersFlag.get())) {
            return;
        }
        this.registerLayer(lexer, startTokens);
        this.mySelfStoppingLexers.add(lexer);
        this.myStopTokens.put(lexer, stopTokens);
    }

    public void registerLayer(Lexer lexer, IElementType ... startTokens) {
        if (Boolean.TRUE.equals(ourDisableLayersFlag.get())) {
            return;
        }
        for (IElementType startToken : startTokens) {
            LOG.assertTrue(!this.myStartTokenToLayerLexer.containsKey(startToken));
            this.myStartTokenToLayerLexer.put(startToken, lexer);
        }
    }

    private void activateLayerIfNecessary() {
        IElementType baseTokenType = super.getTokenType();
        this.myCurrentLayerLexer = this.findLayerLexer(baseTokenType);
        if (this.myCurrentLayerLexer != null) {
            this.myCurrentBaseTokenType = baseTokenType;
            this.myBaseTokenEnd = super.getTokenEnd();
            this.myCurrentLayerLexer.start(super.getBufferSequence(), super.getTokenStart(), super.getTokenEnd());
            if (this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer)) {
                super.advance();
            }
        }
    }

    @Nullable
    protected Lexer findLayerLexer(IElementType baseTokenType) {
        return this.myStartTokenToLayerLexer.get(baseTokenType);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        LOG.assertTrue(initialState != 1024, (Object)"Restoring to layer is not supported.");
        this.myState = initialState;
        this.myCurrentLayerLexer = null;
        super.start(buffer, startOffset, endOffset, initialState);
        this.activateLayerIfNecessary();
    }

    @Override
    public int getState() {
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.isInLayerEndGap()) {
            return this.myCurrentBaseTokenType;
        }
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenType() : super.getTokenType();
    }

    @Override
    public int getTokenStart() {
        if (this.isInLayerEndGap()) {
            return this.myLayerLeftPart;
        }
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenStart() : super.getTokenStart();
    }

    @Override
    public int getTokenEnd() {
        if (this.isInLayerEndGap()) {
            return this.myBaseTokenEnd;
        }
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenEnd() : super.getTokenEnd();
    }

    @Override
    public void advance() {
        if (this.isInLayerEndGap()) {
            this.myLayerLeftPart = -1;
            this.myState = super.getState();
            return;
        }
        if (this.isLayerActive()) {
            Lexer activeLayerLexer = this.myCurrentLayerLexer;
            IElementType layerTokenType = activeLayerLexer.getTokenType();
            if (!this.isStopToken(this.myCurrentLayerLexer, layerTokenType)) {
                this.myCurrentLayerLexer.advance();
                layerTokenType = this.myCurrentLayerLexer.getTokenType();
            } else {
                layerTokenType = null;
            }
            if (layerTokenType == null) {
                int tokenEnd = this.myCurrentLayerLexer.getTokenEnd();
                boolean selfStopping = this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer);
                this.myCurrentLayerLexer = null;
                if (!selfStopping) {
                    super.advance();
                } else if (tokenEnd != this.myBaseTokenEnd) {
                    this.myState = 2048;
                    this.myLayerLeftPart = tokenEnd;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("We've got not covered gap from layered lexer: " + activeLayerLexer + "\n on token: " + this.getBufferSequence().subSequence(this.myLayerLeftPart, this.myBaseTokenEnd));
                    }
                    return;
                }
                this.activateLayerIfNecessary();
            }
        } else {
            super.advance();
            this.activateLayerIfNecessary();
        }
        this.myState = this.isLayerActive() ? 1024 : super.getState();
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        return new LexerPositionImpl(this.getTokenStart(), this.getState());
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), position.getState());
    }

    private boolean isStopToken(Lexer lexer, IElementType tokenType) {
        IElementType[] stopTokens = this.myStopTokens.get(lexer);
        if (stopTokens == null) {
            return false;
        }
        for (IElementType stopToken : stopTokens) {
            if (stopToken != tokenType) continue;
            return true;
        }
        return false;
    }

    protected boolean isLayerActive() {
        return this.myCurrentLayerLexer != null;
    }

    private boolean isInLayerEndGap() {
        return this.myLayerLeftPart != -1;
    }
}

