/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.Symbol;
import com.intellij.model.SymbolResolveResult;
import com.intellij.model.psi.PsiElementSymbol;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface SymbolService {
    @Contract(pure=true)
    @NotNull
    public static Symbol adaptPsiElement(@NotNull PsiElement element) {
        if (element instanceof Symbol) {
            return (Symbol)((Object)element);
        }
        return new PsiElementSymbol(element);
    }

    @Contract(pure=true)
    @NotNull
    public static SymbolResolveResult resolveResult(@NotNull PsiElement element) {
        final Symbol symbol = SymbolService.adaptPsiElement(element);
        return new SymbolResolveResult(){

            @Override
            @NotNull
            public Symbol getTarget() {
                return symbol;
            }
        };
    }
}

