/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.Notification");
    private static final DataKey<Notification> KEY = DataKey.create("Notification");
    public final String id;
    private final String myGroupId;
    private Icon myIcon;
    private final NotificationType myType;
    private String myTitle;
    private String mySubtitle;
    private String myContent;
    private NotificationListener myListener;
    private String myDropDownText;
    private List<AnAction> myActions;
    private AnAction myContextHelpAction;
    private final AtomicBoolean myExpired = new AtomicBoolean(false);
    private Runnable myWhenExpired;
    private Boolean myImportant;
    private WeakReference<Balloon> myBalloonRef;
    private final long myTimestamp;

    public Notification(@NotNull String groupDisplayId, @Nullable Icon icon, @NotNull NotificationType type) {
        this(groupDisplayId, icon, null, null, null, type, null);
    }

    public Notification(@NotNull String groupDisplayId, @Nullable Icon icon, @Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        this.myGroupId = groupDisplayId;
        this.myTitle = StringUtil.notNullize((String)title);
        this.myContent = StringUtil.notNullize((String)content);
        this.myType = type;
        this.myListener = listener;
        this.myTimestamp = System.currentTimeMillis();
        this.myIcon = icon;
        this.mySubtitle = subtitle;
        this.id = Notification.calculateId(this);
    }

    public Notification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type) {
        this(groupDisplayId, title, content, type, null);
    }

    public Notification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        this.myGroupId = groupDisplayId;
        this.myTitle = title;
        this.myContent = content;
        this.myType = type;
        this.myListener = listener;
        this.myTimestamp = System.currentTimeMillis();
        this.id = Notification.calculateId(this);
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Notification setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        return this;
    }

    @NotNull
    public String getGroupId() {
        return this.myGroupId;
    }

    public boolean hasTitle() {
        return !StringUtil.isEmptyOrSpaces((String)this.myTitle) || !StringUtil.isEmptyOrSpaces((String)this.mySubtitle);
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public Notification setTitle(@Nullable String title) {
        this.myTitle = StringUtil.notNullize((String)title);
        return this;
    }

    @NotNull
    public Notification setTitle(@Nullable String title, @Nullable String subtitle) {
        return this.setTitle(title).setSubtitle(subtitle);
    }

    @Nullable
    public String getSubtitle() {
        return this.mySubtitle;
    }

    @NotNull
    public Notification setSubtitle(@Nullable String subtitle) {
        this.mySubtitle = subtitle;
        return this;
    }

    public boolean hasContent() {
        return !StringUtil.isEmptyOrSpaces((String)this.myContent);
    }

    @NotNull
    public String getContent() {
        return this.myContent;
    }

    @NotNull
    public Notification setContent(@Nullable String content) {
        this.myContent = StringUtil.notNullize((String)content);
        return this;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public Notification setListener(@NotNull NotificationListener listener) {
        this.myListener = listener;
        return this;
    }

    @NotNull
    public List<AnAction> getActions() {
        return ContainerUtil.notNullize(this.myActions);
    }

    @NotNull
    public static Notification get(@NotNull AnActionEvent e) {
        return e.getData(KEY);
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action) {
        Notification.fire(notification, action, null);
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action, @Nullable DataContext context) {
        AnActionEvent event = AnActionEvent.createFromAnAction(action, null, "unknown", dataId -> {
            if (KEY.is(dataId)) {
                return notification;
            }
            return context == null ? null : context.getData(dataId);
        });
        if (ActionUtil.lastUpdateAndCheckDumb(action, event, false)) {
            ActionUtil.performActionDumbAwareWithCallbacks(action, event, event.getDataContext());
        }
    }

    public static void setDataProvider(@NotNull Notification notification, @NotNull JComponent component) {
        DataManager.registerDataProvider(component, dataId -> KEY.getName().equals(dataId) ? notification : null);
    }

    @NotNull
    public String getDropDownText() {
        if (this.myDropDownText == null) {
            this.myDropDownText = "Actions";
        }
        return this.myDropDownText;
    }

    @NotNull
    public Notification setDropDownText(@NotNull String dropDownText) {
        this.myDropDownText = dropDownText;
        return this;
    }

    @NotNull
    public Notification addAction(@NotNull AnAction action) {
        if (this.myActions == null) {
            this.myActions = new ArrayList<AnAction>();
        }
        this.myActions.add(action);
        return this;
    }

    public Notification setContextHelpAction(AnAction action) {
        this.myContextHelpAction = action;
        return this;
    }

    public AnAction getContextHelpAction() {
        return this.myContextHelpAction;
    }

    @NotNull
    public NotificationType getType() {
        return this.myType;
    }

    public boolean isExpired() {
        return this.myExpired.get();
    }

    public void expire() {
        if (!this.myExpired.compareAndSet(false, true)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(this::hideBalloon);
        NotificationsManager.getNotificationsManager().expire(this);
        Runnable whenExpired = this.myWhenExpired;
        if (whenExpired != null) {
            whenExpired.run();
        }
    }

    public Notification whenExpired(@Nullable Runnable whenExpired) {
        this.myWhenExpired = whenExpired;
        return this;
    }

    public void hideBalloon() {
        if (this.myBalloonRef != null) {
            Balloon balloon = (Balloon)this.myBalloonRef.get();
            if (balloon != null) {
                balloon.hide();
            }
            this.myBalloonRef = null;
        }
    }

    public void setBalloon(final @NotNull Balloon balloon) {
        this.hideBalloon();
        this.myBalloonRef = new WeakReference<Balloon>(balloon);
        balloon.addListener(new JBPopupAdapter(){

            @Override
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (SoftReference.dereference((Reference)Notification.this.myBalloonRef) == balloon) {
                    Notification.this.myBalloonRef = null;
                }
            }
        });
    }

    @Nullable
    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference(this.myBalloonRef);
    }

    public void notify(@Nullable Project project) {
        Notifications.Bus.notify(this, project);
    }

    public Notification setImportant(boolean important) {
        this.myImportant = important;
        return this;
    }

    public boolean isImportant() {
        if (this.myImportant != null) {
            return this.myImportant;
        }
        return this.getListener() != null || !ContainerUtil.isEmpty(this.myActions);
    }

    @NotNull
    private static String calculateId(@NotNull Object notification) {
        return System.currentTimeMillis() + "." + System.identityHashCode(notification);
    }

    public final void assertHasTitleOrContent() {
        LOG.assertTrue(this.hasTitle() || this.hasContent(), (Object)("Notification should have title and/or content; groupId: " + this.myGroupId));
    }
}

