/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NotificationAction
extends DumbAwareAction {
    public NotificationAction(@Nullable String text) {
        super(text);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        this.actionPerformed(e, Notification.get(e));
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Notification var2);

    @NotNull
    public static NotificationAction create(@NotNull String text, final @NotNull BiConsumer<? super AnActionEvent, ? super Notification> performAction) {
        return new NotificationAction(text){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                performAction.accept(e, notification);
            }
        };
    }

    @NotNull
    public static NotificationAction createSimple(@NotNull String text, @NotNull Runnable performAction) {
        return NotificationAction.create(text, (? super AnActionEvent event, ? super Notification notification) -> performAction.run());
    }
}

