/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.NotificationGroup");
    private static final Map<String, NotificationGroup> ourRegisteredGroups = ContainerUtil.newConcurrentMap();
    @NotNull
    private final String myDisplayId;
    @NotNull
    private final NotificationDisplayType myDisplayType;
    private final boolean myLogByDefault;
    @Nullable
    private final String myToolWindowId;
    private final Icon myIcon;
    private String myParentId;

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault) {
        this(displayId, defaultDisplayType, logByDefault, null);
    }

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault, @Nullable String toolWindowId) {
        this(displayId, defaultDisplayType, logByDefault, toolWindowId, null);
    }

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault, @Nullable String toolWindowId, @Nullable Icon icon) {
        this.myDisplayId = displayId;
        this.myDisplayType = defaultDisplayType;
        this.myLogByDefault = logByDefault;
        this.myToolWindowId = toolWindowId;
        this.myIcon = icon;
        if (ourRegisteredGroups.containsKey(displayId)) {
            LOG.info("Notification group " + displayId + " is already registered", new Throwable());
        }
        ourRegisteredGroups.put(displayId, this);
    }

    @NotNull
    public static NotificationGroup balloonGroup(@NotNull String displayId) {
        return new NotificationGroup(displayId, NotificationDisplayType.BALLOON, true);
    }

    @NotNull
    public static NotificationGroup logOnlyGroup(@NotNull String displayId) {
        return new NotificationGroup(displayId, NotificationDisplayType.NONE, true);
    }

    @NotNull
    public static NotificationGroup toolWindowGroup(@NotNull String displayId, @NotNull String toolWindowId, boolean logByDefault) {
        return new NotificationGroup(displayId, NotificationDisplayType.TOOL_WINDOW, logByDefault, toolWindowId);
    }

    @NotNull
    public static NotificationGroup toolWindowGroup(@NotNull String displayId, @NotNull String toolWindowId) {
        return NotificationGroup.toolWindowGroup(displayId, toolWindowId, true);
    }

    @NotNull
    public String getDisplayId() {
        return this.myDisplayId;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public Notification createNotification(@NotNull String content, @NotNull MessageType type) {
        return this.createNotification(content, type.toNotificationType());
    }

    @NotNull
    public Notification createNotification(@NotNull String content, @NotNull NotificationType type) {
        return this.createNotification("", content, type, null);
    }

    @NotNull
    public Notification createNotification(@NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        return new Notification(this.myDisplayId, title, content, type, listener);
    }

    @NotNull
    public Notification createNotification() {
        return this.createNotification(NotificationType.INFORMATION);
    }

    @NotNull
    public Notification createNotification(@NotNull NotificationType type) {
        return this.createNotification(null, null, null, type, null);
    }

    @NotNull
    public Notification createNotification(@Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type) {
        return this.createNotification(title, subtitle, content, type, null);
    }

    @NotNull
    public Notification createNotification(@Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        return new Notification(this.myDisplayId, this.myIcon, title, subtitle, content, type, listener);
    }

    @Nullable
    public String getParentId() {
        return this.myParentId;
    }

    @NotNull
    public NotificationGroup setParentId(@NotNull String parentId) {
        this.myParentId = parentId;
        return this;
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        return this.myDisplayType;
    }

    public boolean isLogByDefault() {
        return this.myLogByDefault;
    }

    @Nullable
    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    @Nullable
    public static NotificationGroup findRegisteredGroup(String displayId) {
        return ourRegisteredGroups.get(displayId);
    }

    @NotNull
    public static Iterable<NotificationGroup> getAllRegisteredGroups() {
        return ourRegisteredGroups.values();
    }
}

