/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Notifications {
    public static final Topic<Notifications> TOPIC = Topic.create((String)"Notifications", Notifications.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    public static final String SYSTEM_MESSAGES_GROUP_ID = "System Messages";

    public void notify(@NotNull Notification var1);

    public void register(@NotNull String var1, @NotNull NotificationDisplayType var2);

    public void register(@NotNull String var1, @NotNull NotificationDisplayType var2, boolean var3);

    public void register(@NotNull String var1, @NotNull NotificationDisplayType var2, boolean var3, boolean var4);

    public static class Bus {
        @Deprecated
        public static void register(@NotNull String group_id, @NotNull NotificationDisplayType defaultDisplayType) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).register(group_id, defaultDisplayType);
                }
            });
        }

        public static void notify(@NotNull Notification notification) {
            Bus.notify(notification, null);
        }

        public static void notify(@NotNull Notification notification, @Nullable Project project) {
            notification.assertHasTitleOrContent();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Bus.doNotify(notification, project);
            } else {
                UIUtil.invokeLaterIfNeeded(() -> Bus.doNotify(notification, project));
            }
        }

        private static void doNotify(Notification notification, @Nullable Project project) {
            if (project != null && !project.isDisposed() && !project.isDefault()) {
                ((Notifications)project.getMessageBus().syncPublisher(TOPIC)).notify(notification);
            } else {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).notify(notification);
                }
            }
        }
    }
}

