/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionGroupUtil {
    private static Presentation getPresentation(AnAction action, Map<AnAction, Presentation> action2presentation) {
        return action2presentation.computeIfAbsent(action, k -> action.getTemplatePresentation().clone());
    }

    @Deprecated
    public static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        return ActionGroupUtil.isGroupEmpty(actionGroup, e, new HashMap<AnAction, Presentation>(), false);
    }

    public static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, boolean isInModalContext) {
        return ActionGroupUtil.isGroupEmpty(actionGroup, e, new HashMap<AnAction, Presentation>(), isInModalContext);
    }

    private static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, @NotNull Map<AnAction, Presentation> action2presentation, boolean inModalContext) {
        AnAction[] actions;
        for (AnAction action : actions = actionGroup.getChildren(e)) {
            if (action instanceof Separator || !ActionGroupUtil.isActionEnabledAndVisible(action, e, inModalContext, action2presentation)) continue;
            if (action instanceof ActionGroup) {
                if (ActionGroupUtil.isGroupEmpty((ActionGroup)action, e, action2presentation, inModalContext)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static AnAction getSingleActiveAction(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, boolean isInModalContext) {
        List<AnAction> children = ActionGroupUtil.getEnabledChildren(actionGroup, e, new HashMap<AnAction, Presentation>(), isInModalContext);
        if (children.size() == 1) {
            return children.get(0);
        }
        return null;
    }

    private static List<AnAction> getEnabledChildren(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, @NotNull Map<AnAction, Presentation> action2presentation, boolean isInModalContext) {
        AnAction[] actions;
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        for (AnAction action : actions = actionGroup.getChildren(e)) {
            if (action instanceof ActionGroup) {
                if (!ActionGroupUtil.isActionEnabledAndVisible(action, e, isInModalContext, action2presentation)) continue;
                result2.addAll(ActionGroupUtil.getEnabledChildren((ActionGroup)action, e, action2presentation, isInModalContext));
                continue;
            }
            if (action instanceof Separator || !ActionGroupUtil.isActionEnabledAndVisible(action, e, isInModalContext, action2presentation)) continue;
            result2.add(action);
        }
        return result2;
    }

    private static boolean isActionEnabledAndVisible(@NotNull AnAction action, @NotNull AnActionEvent e, boolean isInModalContext, @NotNull Map<AnAction, Presentation> action2presentation) {
        Presentation presentation = ActionGroupUtil.getPresentation(action, action2presentation);
        return ActionGroupUtil.isActionEnabledAndVisible(action, e, isInModalContext, presentation);
    }

    public static boolean isActionEnabledAndVisible(@NotNull AnAction action, @NotNull AnActionEvent e, boolean isInModalContext) {
        Presentation presentation = action.getTemplatePresentation().clone();
        return ActionGroupUtil.isActionEnabledAndVisible(action, e, isInModalContext, presentation);
    }

    private static boolean isActionEnabledAndVisible(@NotNull AnAction action, @NotNull AnActionEvent e, boolean isInModalContext, @NotNull Presentation presentation) {
        AnActionEvent event = new AnActionEvent(e.getInputEvent(), e.getDataContext(), e.getPlace(), presentation, ActionManager.getInstance(), e.getModifiers());
        event.setInjectedContext(action.isInInjectedContext());
        ActionUtil.performDumbAwareUpdate(isInModalContext, action, event, false);
        return presentation.isEnabled() && presentation.isVisible();
    }
}

