/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ActionStub
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.ActionStub");
    private final String myClassName;
    private final String myProjectType;
    private final Supplier<Presentation> myTemplatePresentation;
    private final String myId;
    private final ClassLoader myLoader;
    private final PluginId myPluginId;
    private final String myIconPath;

    public ActionStub(@NotNull String actionClass, @NotNull String id, ClassLoader loader, PluginId pluginId, String iconPath, String projectType, @NotNull Supplier<Presentation> templatePresentation) {
        this.myLoader = loader;
        this.myClassName = actionClass;
        this.myProjectType = projectType;
        this.myTemplatePresentation = templatePresentation;
        LOG.assertTrue(!id.isEmpty());
        this.myId = id;
        this.myPluginId = pluginId;
        this.myIconPath = iconPath;
    }

    @Override
    @NotNull
    Presentation createTemplatePresentation() {
        return this.myTemplatePresentation.get();
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    public ClassLoader getLoader() {
        return this.myLoader;
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    public String getIconPath() {
        return this.myIconPath;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        throw new UnsupportedOperationException();
    }

    public final void initAction(@NotNull AnAction targetAction) {
        Presentation sourcePresentation = this.getTemplatePresentation();
        Presentation targetPresentation = targetAction.getTemplatePresentation();
        if (targetPresentation.getIcon() == null && sourcePresentation.getIcon() != null) {
            targetPresentation.setIcon(sourcePresentation.getIcon());
        }
        if (StringUtil.isEmpty((String)targetPresentation.getText()) && sourcePresentation.getText() != null) {
            targetPresentation.setText(sourcePresentation.getTextWithMnemonic(), true);
        }
        if (targetPresentation.getDescription() == null && sourcePresentation.getDescription() != null) {
            targetPresentation.setDescription(sourcePresentation.getDescription());
        }
        targetAction.setShortcutSet(this.getShortcutSet());
        targetAction.markAsGlobal();
    }

    public String getProjectType() {
        return this.myProjectType;
    }
}

