/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public final class CustomShortcutSet
implements ShortcutSet {
    public static final CustomShortcutSet EMPTY = new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
    private final Shortcut[] myShortcuts;

    public CustomShortcutSet(@NotNull KeyStroke keyStroke) {
        this(new KeyboardShortcut(keyStroke, null));
    }

    public CustomShortcutSet(Shortcut ... shortcuts) {
        this.myShortcuts = shortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])shortcuts.clone();
    }

    public CustomShortcutSet(Integer ... keyCodes) {
        this.myShortcuts = (Shortcut[])ContainerUtil.map((Object[])keyCodes, integer -> new KeyboardShortcut(KeyStroke.getKeyStroke(integer, 0), null), (Object[])Shortcut.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public Shortcut[] getShortcuts() {
        return this.myShortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])this.myShortcuts.clone();
    }

    @NotNull
    public static CustomShortcutSet fromString(String ... keyboardShortcuts) {
        Shortcut[] shortcuts = new KeyboardShortcut[keyboardShortcuts.length];
        for (int i = 0; i < keyboardShortcuts.length; ++i) {
            shortcuts[i] = KeyboardShortcut.fromString(keyboardShortcuts[i]);
        }
        return new CustomShortcutSet(shortcuts);
    }
}

