/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.DefaultActionGroup");
    private static final String CANT_ADD_ITSELF = "Cannot add a group to itself: ";
    private static final String CANT_ADD_ACTION_TWICE = "Cannot add an action twice: ";
    private final List<AnAction> mySortedChildren = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Pair<AnAction, Constraints>> myPairs = ContainerUtil.createLockFreeCopyOnWriteList();

    public DefaultActionGroup() {
        this(null, false);
    }

    public DefaultActionGroup(AnAction ... actions) {
        this(Arrays.asList(actions));
    }

    public DefaultActionGroup(@NotNull List<? extends AnAction> actions) {
        this(null, actions);
    }

    public DefaultActionGroup(@Nullable String name, @NotNull List<? extends AnAction> actions) {
        this(name, false);
        this.addActions(actions);
    }

    public DefaultActionGroup(@Nullable String shortName, boolean popup) {
        super(shortName, popup);
    }

    private void addActions(@NotNull List<? extends AnAction> actions) {
        HashSet<AnAction> actionSet = new HashSet<AnAction>();
        ArrayList<AnAction> uniqueActions = new ArrayList<AnAction>(actions.size());
        for (AnAction anAction : actions) {
            if (anAction == this) {
                throw new IllegalArgumentException(CANT_ADD_ITSELF + anAction);
            }
            if (!(anAction instanceof Separator) && !actionSet.add(anAction)) {
                LOG.error(CANT_ADD_ACTION_TWICE + anAction);
                continue;
            }
            uniqueActions.add(anAction);
        }
        this.mySortedChildren.addAll(uniqueActions);
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        this.add(action, Constraints.LAST, actionManager);
    }

    public final void add(@NotNull AnAction action) {
        this.addAction(action, Constraints.LAST);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action) {
        return this.addAction(action, Constraints.LAST);
    }

    public final void addSeparator() {
        this.add(Separator.create());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        this.add(action, constraint, ActionManager.getInstance());
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        return this.addAction(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        this.addAction(action, constraint, actionManager);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == this) {
            throw new IllegalArgumentException(CANT_ADD_ITSELF + action);
        }
        if (!(action instanceof Separator) && this.containsAction(action)) {
            LOG.error(CANT_ADD_ACTION_TWICE + action);
            return new ActionInGroup(this, action);
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else if (this.addToSortedList(action, constraint, actionManager)) {
            this.actionAdded(action, actionManager);
        } else {
            this.myPairs.add((Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)constraint));
        }
        return new ActionInGroup(this, action);
    }

    private boolean containsAction(@NotNull AnAction action) {
        if (this.mySortedChildren.contains(action)) {
            return true;
        }
        for (Pair<AnAction, Constraints> pair : this.myPairs) {
            if (!action.equals(pair.first)) continue;
            return true;
        }
        return false;
    }

    private void actionAdded(@NotNull AnAction addedAction, @NotNull ActionManager actionManager) {
        String addedActionId;
        String string = addedActionId = addedAction instanceof ActionStub ? ((ActionStub)addedAction).getId() : actionManager.getId(addedAction);
        if (addedActionId == null) {
            return;
        }
        block0: while (!this.myPairs.isEmpty()) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        int index2 = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager);
        if (index2 == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index2, action);
        } else {
            this.mySortedChildren.add(index2 + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, @NotNull List<? extends AnAction> actions, @NotNull ActionManager actionManager) {
        for (int i = 0; i < actions.size(); ++i) {
            String id;
            AnAction action = actions.get(i);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i;
        }
        return -1;
    }

    public final void remove(@NotNull AnAction action) {
        String id = ActionManager.getInstance().getId(action);
        this.remove(action, id);
    }

    public final void remove(@NotNull AnAction action, @Nullable String id) {
        if (!this.mySortedChildren.remove(action) && !this.mySortedChildren.removeIf(oldAction -> oldAction instanceof ActionStub && ((ActionStub)oldAction).getId().equals(id))) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!((AnAction)pair.first).equals(action) && (!(pair.first instanceof ActionStub) || !((ActionStub)pair.first).getId().equals(id))) continue;
                this.myPairs.remove(i);
                break;
            }
        }
    }

    public final void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
    }

    public boolean replaceAction(@NotNull AnAction oldAction, @NotNull AnAction newAction) {
        int index2 = this.mySortedChildren.indexOf(oldAction);
        if (index2 >= 0) {
            this.mySortedChildren.set(index2, newAction);
            return true;
        }
        for (int i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            if (!((AnAction)pair.first).equals(newAction)) continue;
            this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)newAction, (Object)pair.second));
            return true;
        }
        return false;
    }

    public void copyFromGroup(@NotNull DefaultActionGroup other) {
        this.copyFrom(other);
        this.setPopup(other.isPopup());
        this.mySortedChildren.clear();
        this.mySortedChildren.addAll(other.mySortedChildren);
        this.myPairs.clear();
        this.myPairs.addAll(other.myPairs);
    }

    @Override
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        int i;
        boolean hasNulls = false;
        int sortedSize = this.mySortedChildren.size();
        Object[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            AnAction action = this.mySortedChildren.get(i);
            if (action == null) {
                LOG.error("Empty sorted child: " + this + ", " + this.getClass() + "; index=" + i);
            }
            if (action instanceof ActionStub) {
                if ((action = this.unStub(e, (ActionStub)action)) == null) {
                    LOG.error("Can't unstub " + this.mySortedChildren.get(i));
                } else {
                    this.mySortedChildren.set(i, action);
                }
            }
            hasNulls |= action == null;
            children[i] = action;
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            AnAction action = (AnAction)pair.first;
            if (action == null) {
                LOG.error("Empty pair child: " + this + ", " + this.getClass() + "; index=" + i);
            } else if (action instanceof ActionStub) {
                if ((action = this.unStub(e, (ActionStub)action)) == null) {
                    LOG.error("Can't unstub " + pair);
                } else {
                    this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)pair.second));
                }
            }
            hasNulls |= action == null;
            children[i + sortedSize] = action;
        }
        if (hasNulls) {
            return (AnAction[])ContainerUtil.mapNotNull((Object[])children, (Function)FunctionUtil.id(), (Object[])AnAction.EMPTY_ARRAY);
        }
        return children;
    }

    @Nullable
    private AnAction unStub(@Nullable AnActionEvent e, @NotNull ActionStub stub) {
        ActionManager actionManager = e != null ? e.getActionManager() : ActionManager.getInstance();
        try {
            AnAction action = actionManager.getAction(stub.getId());
            if (action == null) {
                LOG.error("Null child action in group " + this + " of class " + this.getClass() + ", id=" + stub.getId());
                return null;
            }
            this.replace(stub, action);
            return action;
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable e1) {
            LOG.error(e1);
            return null;
        }
    }

    public final int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    @NotNull
    public final AnAction[] getChildActionsOrStubs() {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            children[i + sortedSize] = (AnAction)this.myPairs.get((int)i).first;
        }
        return children;
    }

    public final void addAll(@NotNull ActionGroup group) {
        for (AnAction each : group.getChildren(null)) {
            this.add(each);
        }
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList) {
        for (AnAction anAction : actionList) {
            this.add(anAction);
        }
    }

    public final void addAll(AnAction ... actions) {
        for (AnAction each : actions) {
            this.add(each);
        }
    }

    public void addSeparator(@Nullable String separatorText) {
        this.add(Separator.create(separatorText));
    }

    public static DefaultActionGroup createUserDataAwareGroup(final String templateText) {
        return new DefaultActionGroup(){

            @Override
            @Nullable
            public String getTemplateText() {
                return templateText;
            }
        };
    }
}

