/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class CheckboxAction
extends ToggleAction
implements CustomComponentAction {
    protected CheckboxAction() {
    }

    protected CheckboxAction(String text) {
        super(text);
    }

    protected CheckboxAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JCheckBox checkBox = new JCheckBox();
        this.updateCustomComponent(checkBox, presentation);
        return CheckboxAction.createCheckboxComponent(checkBox, this, place);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        JComponent property2 = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (property2 instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)property2;
            this.updateCustomComponent(checkBox, presentation);
        }
    }

    protected void updateCustomComponent(JCheckBox checkBox, Presentation presentation) {
        CheckboxAction.updateCheckboxPresentation(checkBox, presentation);
        checkBox.setSelected(Boolean.TRUE.equals(presentation.getClientProperty("selected")));
    }

    static void updateCheckboxPresentation(JCheckBox checkBox, Presentation presentation) {
        checkBox.setText(presentation.getText());
        checkBox.setToolTipText(presentation.getDescription());
        checkBox.setMnemonic(presentation.getMnemonic());
        checkBox.setDisplayedMnemonicIndex(presentation.getDisplayedMnemonicIndex());
        checkBox.setEnabled(presentation.isEnabled());
        checkBox.setVisible(presentation.isVisible());
    }

    @NotNull
    static JComponent createCheckboxComponent(@NotNull JCheckBox checkBox, final @NotNull AnAction action, final @NotNull String place) {
        checkBox.setOpaque(false);
        checkBox.setBorder((Border)JBUI.Borders.emptyRight((int)9));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                ActionToolbar actionToolbar = (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)checkBox);
                DataContext dataContext = actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext(checkBox);
                action.actionPerformed(AnActionEvent.createFromAnAction(action, null, place, dataContext));
            }
        });
        return checkBox;
    }
}

