/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ThreeStateCheckBox;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ThreeStateCheckboxAction
extends AnAction
implements CustomComponentAction {
    @NonNls
    public static final String STATE_PROPERTY = "three_state_selected";

    protected ThreeStateCheckboxAction() {
    }

    protected ThreeStateCheckboxAction(String text) {
        super(text);
    }

    protected ThreeStateCheckboxAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    public abstract ThreeStateCheckBox.State isSelected(AnActionEvent var1);

    public abstract void setSelected(AnActionEvent var1, @NotNull ThreeStateCheckBox.State var2);

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        ThreeStateCheckBox.State state = this.isSelected(e);
        Presentation presentation = e.getPresentation();
        presentation.putClientProperty(STATE_PROPERTY, state);
        this.setSelected(e, ThreeStateCheckBox.nextState((ThreeStateCheckBox.State)state, (boolean)true));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        ThreeStateCheckBox.State state = this.isSelected(e);
        Presentation presentation = e.getPresentation();
        presentation.putClientProperty(STATE_PROPERTY, state);
        JComponent property2 = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (property2 instanceof ThreeStateCheckBox) {
            ThreeStateCheckBox checkBox = (ThreeStateCheckBox)property2;
            this.updateCustomComponent(checkBox, presentation);
        }
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        ThreeStateCheckBox checkBox = new ThreeStateCheckBox();
        this.updateCustomComponent(checkBox, presentation);
        return CheckboxAction.createCheckboxComponent((JCheckBox)checkBox, this, place);
    }

    protected void updateCustomComponent(ThreeStateCheckBox checkBox, Presentation presentation) {
        CheckboxAction.updateCheckboxPresentation((JCheckBox)checkBox, presentation);
        ThreeStateCheckBox.State property2 = (ThreeStateCheckBox.State)ObjectUtils.tryCast((Object)presentation.getClientProperty(STATE_PROPERTY), ThreeStateCheckBox.State.class);
        checkBox.setState((ThreeStateCheckBox.State)ObjectUtils.chooseNotNull((Object)property2, (Object)ThreeStateCheckBox.State.NOT_SELECTED));
    }
}

