/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AsyncExecutionService;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

public interface AppUIExecutor {
    @NotNull
    public static AppUIExecutor onUiThread(@NotNull ModalityState modality) {
        return AsyncExecutionService.getService().createUIExecutor(modality);
    }

    @NotNull
    public static AppUIExecutor onUiThread() {
        return AppUIExecutor.onUiThread(ModalityState.defaultModalityState());
    }

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor later();

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor withDocumentsCommitted(@NotNull Project var1);

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor inSmartMode(@NotNull Project var1);

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor inTransaction(@NotNull Disposable var1);

    @NotNull
    @Contract(pure=true)
    public AppUIExecutor expireWith(@NotNull Disposable var1);

    public void execute(@NotNull Runnable var1);

    public <T> CancellablePromise<T> submit(@NotNull Callable<T> var1);

    public CancellablePromise<?> submit(@NotNull Runnable var1);
}

