/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationNamesInfo {
    private static final String COMPONENT_NAME = "ApplicationInfo";
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        return prefix != null ? prefix + COMPONENT_NAME : COMPONENT_NAME;
    }

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        return ApplicationNamesInfoHolder.ourInstance;
    }

    private ApplicationNamesInfo() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            Element rootElement = JDOMUtil.load(ApplicationNamesInfo.class, (String)resource);
            Element names = rootElement.getChild("names", rootElement.getNamespace());
            this.myProductName = names.getAttributeValue("product");
            this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
            this.myEditionName = names.getAttributeValue("edition");
            this.myScriptName = names.getAttributeValue("script");
            this.myDefaultLauncherName = names.getAttributeValue("default-launcher-name", this.myScriptName);
            this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    public String getProductName() {
        return this.myProductName;
    }

    public String getFullProductName() {
        return this.myFullProductName;
    }

    public String getFullProductNameWithEdition() {
        return this.myEditionName != null ? this.myFullProductName + ' ' + this.myEditionName : this.myFullProductName;
    }

    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        return StringUtil.capitalize((String)this.myProductName.toLowerCase(Locale.US));
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public String getDefaultLauncherName() {
        return this.myDefaultLauncherName;
    }

    @NotNull
    public String getMotto() {
        return this.myMotto;
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();

        private ApplicationNamesInfoHolder() {
        }
    }
}

