/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryParameters;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class QueryExecutorBase<Result, Params>
implements QueryExecutor<Result, Params> {
    private final boolean myRequireReadAction;

    protected QueryExecutorBase(boolean requireReadAction) {
        this.myRequireReadAction = requireReadAction;
    }

    protected QueryExecutorBase() {
        this(false);
    }

    @Override
    public final boolean execute(@NotNull Params queryParameters, @NotNull Processor<? super Result> consumer) {
        AtomicBoolean toContinue = new AtomicBoolean(true);
        Processor wrapper = result2 -> {
            if (!toContinue.get()) {
                return false;
            }
            if (!consumer.process(result2)) {
                toContinue.set(false);
                return false;
            }
            return true;
        };
        if (this.myRequireReadAction && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            Runnable runnable = () -> {
                if (!(queryParameters instanceof QueryParameters) || ((QueryParameters)queryParameters).isQueryValid()) {
                    this.processQuery(queryParameters, wrapper);
                }
            };
            if (!DumbService.isDumbAware(this)) {
                Project project;
                Project project2 = project = queryParameters instanceof QueryParameters ? ((QueryParameters)queryParameters).getProject() : null;
                if (project != null) {
                    DumbService.getInstance(project).runReadActionInSmartMode(runnable);
                    return toContinue.get();
                }
            }
            ApplicationManager.getApplication().runReadAction(runnable);
        } else {
            this.processQuery(queryParameters, wrapper);
        }
        return toContinue.get();
    }

    public abstract void processQuery(@NotNull Params var1, @NotNull Processor<? super Result> var2);
}

