/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.WriteAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @NotNull
    public RunResult<T> execute() {
        RunResult result2 = new RunResult(this);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            AccessToken token = WriteAction.start(this.getClass());
            try {
                result2.run();
            }
            finally {
                token.finish();
            }
            return result2;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        TransactionGuard.getInstance().submitTransactionAndWait(() -> {
            AccessToken token = WriteAction.start(this.getClass());
            try {
                result2.run();
            }
            finally {
                token.finish();
            }
        });
        if (!this.isSilentExecution()) {
            result2.throwException();
        }
        return result2;
    }

    @Deprecated
    @NotNull
    public static AccessToken start() {
        Class callerClass = (Class)ObjectUtils.notNull((Object)ReflectionUtil.getCallerClass((int)3), WriteAction.class);
        return WriteAction.start(callerClass);
    }

    @Deprecated
    @NotNull
    private static AccessToken start(@NotNull Class clazz) {
        return ApplicationManager.getApplication().acquireWriteActionLock(clazz);
    }

    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
        AccessToken token = WriteAction.start(action.getClass());
        try {
            action.run();
        }
        finally {
            token.finish();
        }
    }

    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> action) throws E {
        return ApplicationManager.getApplication().runWriteAction(action);
    }

    @Override
    @Deprecated
    protected abstract void run(@NotNull Result<T> var1) throws Throwable;

    public static <E extends Throwable> void runAndWait(@NotNull ThrowableRunnable<E> action) throws E {
        WriteAction.computeAndWait(() -> {
            action.run();
            return null;
        });
    }

    public static <T, E extends Throwable> T computeAndWait(@NotNull ThrowableComputable<T, E> action) throws E {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            return ApplicationManager.getApplication().runWriteAction(action);
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        AtomicReference result2 = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        TransactionGuard.getInstance().submitTransactionAndWait(() -> {
            try {
                result2.set(WriteAction.compute(action));
            }
            catch (Throwable e) {
                exception.set(e);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            t.addSuppressed(new RuntimeException());
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            Throwable e = t;
            throw e;
        }
        return (T)result2.get();
    }
}

