/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UndoManager {
    public static final Key<Document> ORIGINAL_DOCUMENT = new Key("ORIGINAL_DOCUMENT");

    public static UndoManager getInstance(@NotNull Project project) {
        return project.getComponent(UndoManager.class);
    }

    public static UndoManager getGlobalInstance() {
        return ApplicationManager.getApplication().getComponent(UndoManager.class);
    }

    public abstract void undoableActionPerformed(@NotNull UndoableAction var1);

    public abstract void nonundoableActionPerformed(@NotNull DocumentReference var1, boolean var2);

    public abstract boolean isUndoInProgress();

    public abstract boolean isRedoInProgress();

    public abstract void undo(@Nullable FileEditor var1);

    public abstract void redo(@Nullable FileEditor var1);

    public abstract boolean isUndoAvailable(@Nullable FileEditor var1);

    public abstract boolean isRedoAvailable(@Nullable FileEditor var1);

    @NotNull
    public abstract Pair<String, String> getUndoActionNameAndDescription(FileEditor var1);

    @NotNull
    public abstract Pair<String, String> getRedoActionNameAndDescription(FileEditor var1);
}

