/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        Application application = ApplicationManager.getApplication();
        return ServiceManager.doGetService(application, serviceClass, true);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        return ServiceManager.doGetService(project, serviceClass, true);
    }

    @Nullable
    public static <T> T getServiceIfCreated(@NotNull Project project, @NotNull Class<T> serviceClass) {
        return ServiceManager.doGetService(project, serviceClass, false);
    }

    @Nullable
    public static <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        return ServiceManager.doGetService(ApplicationManager.getApplication(), serviceClass, false);
    }

    @Nullable
    private static <T> T doGetService(ComponentManager componentManager, @NotNull Class<T> serviceClass, boolean isCreate) {
        String componentKey = serviceClass.getName();
        PicoContainer picoContainer = componentManager.getPicoContainer();
        if (!isCreate && picoContainer instanceof DefaultPicoContainer) {
            return (T)((DefaultPicoContainer)picoContainer).getComponentInstanceIfInstantiated(componentKey);
        }
        Object instance = picoContainer.getComponentInstance((Object)componentKey);
        if (instance == null) {
            ProgressManager.checkCanceled();
            instance = componentManager.getComponent(serviceClass);
            if (instance != null) {
                Application app = ApplicationManager.getApplication();
                String message = componentKey + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
                if (app.isUnitTestMode()) {
                    LOG.error(message);
                } else {
                    LOG.warn(message);
                }
            }
        }
        return (T)instance;
    }

    @NotNull
    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<? extends T> serviceClass) {
        return NotNullLazyKey.create((String)("Service: " + serviceClass.getName()), project -> ServiceManager.getService(project, serviceClass));
    }
}

