/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class StateSplitterEx
implements StateSplitter {
    @Override
    @NotNull
    public abstract List<Pair<Element, String>> splitState(@NotNull Element var1);

    public void mergeStateInto(@NotNull Element target, @NotNull Element subState) {
        target.addContent(subState);
    }

    @Override
    public final void mergeStatesInto(@NotNull Element target, @NotNull Element[] elements) {
        throw new IllegalStateException();
    }

    @NotNull
    protected static List<Pair<Element, String>> splitState(@NotNull Element state, @NotNull String attributeName) {
        UniqueNameGenerator generator = new UniqueNameGenerator();
        SmartList result2 = new SmartList();
        for (Element subState : state.getChildren()) {
            if (subState.getAttribute("__external-system-id") != null) continue;
            result2.add(StateSplitterEx.createItem(subState.getAttributeValue(attributeName), generator, subState));
        }
        return result2;
    }

    @NotNull
    protected static Pair<Element, String> createItem(@NotNull String fileName, @NotNull UniqueNameGenerator generator, @NotNull Element element) {
        return Pair.create((Object)element, (Object)(generator.generateUniqueName(FileUtil.sanitizeFileName((String)fileName)) + ".xml"));
    }

    protected static void mergeStateInto(@NotNull Element target, @NotNull Element subState, @NotNull String subStateName) {
        if (subState.getName().equals(subStateName)) {
            target.addContent(subState);
        } else {
            JDOMUtil.merge((Element)target, (Element)subState);
        }
    }
}

